/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.frame.ThreadComboBoxRenderer;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class XFramesView
implements XDebugView {
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final JComboBox myThreadComboBox;
    private final Set<XExecutionStack> myExecutionStacks;
    @NotNull
    private final XDebugSession mySession;
    private XExecutionStack mySelectedStack;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders;
    private final ActionToolbarImpl myToolbar;
    private final Wrapper myThreadsPanel;

    public XFramesView(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XFramesView", "<init>"));
        }
        this.myExecutionStacks = ContainerUtil.newHashSet();
        this.myBuilders = new HashMap();
        this.mySession = session;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myFramesList = new XDebuggerFramesList(session.getProject());
        this.myFramesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                XFramesView.this.processFrameSelection();
            }
        });
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int i = XFramesView.this.myFramesList.locationToIndex(e.getPoint());
                if (i != -1 && XFramesView.this.myFramesList.isSelectedIndex(i)) {
                    XFramesView.this.processFrameSelection();
                }
            }
        });
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList)), "Center");
        this.myThreadComboBox = new JComboBox();
        this.myThreadComboBox.setRenderer(new ThreadComboBoxRenderer(this.myThreadComboBox));
        this.myThreadComboBox.addItemListener(new MyItemListener());
        this.myToolbar = this.createToolbar();
        this.myThreadsPanel = new Wrapper();
        CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, 1, 0);
        this.myThreadsPanel.setBorder((Border)border);
        this.myThreadsPanel.add((Component)this.myToolbar.getComponent(), (Object)"East");
        this.myMainPanel.add((Component)this.myThreadsPanel, "North");
        this.processSessionEvent(XDebugView.SessionEvent.RESUMED);
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.getFramesList()));
        framesGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.getFramesList()));
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setAddSeparatorFirst(true);
        toolbar.getComponent().setBorder(new EmptyBorder(1, 0, 0, 0));
        return toolbar;
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack) {
        StackFramesListBuilder builder = this.myBuilders.get(executionStack);
        if (builder == null) {
            builder = new StackFramesListBuilder(executionStack);
            this.myBuilders.put(executionStack, builder);
        }
        return builder;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        boolean invisible;
        XExecutionStack[] executionStacks;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XFramesView", "processSessionEvent"));
        }
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        if (event == XDebugView.SessionEvent.FRAME_CHANGED) {
            XStackFrame currentStackFrame = this.mySession.getCurrentStackFrame();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
            }
            return;
        }
        this.myListenersEnabled = false;
        for (StackFramesListBuilder builder : this.myBuilders.values()) {
            builder.dispose();
        }
        this.myBuilders.clear();
        this.mySelectedStack = null;
        XSuspendContext suspendContext = this.mySession.getSuspendContext();
        if (suspendContext == null) {
            this.myThreadComboBox.removeAllItems();
            this.myFramesList.clear();
            this.myExecutionStacks.clear();
            return;
        }
        for (XExecutionStack executionStack : executionStacks = suspendContext.getExecutionStacks()) {
            if (this.myExecutionStacks.contains(executionStack)) continue;
            this.myThreadComboBox.addItem(executionStack);
            this.myExecutionStacks.add(executionStack);
        }
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        this.myThreadComboBox.setSelectedItem(activeExecutionStack);
        this.myThreadsPanel.removeAll();
        this.myThreadsPanel.add((Component)this.myToolbar.getComponent(), (Object)"East");
        boolean bl = invisible = executionStacks.length == 1 && StringUtil.isEmpty((String)executionStacks[0].getDisplayName());
        if (!invisible) {
            this.myThreadsPanel.add((Component)this.myThreadComboBox, (Object)"Center");
        }
        this.myToolbar.setAddSeparatorFirst(!invisible);
        this.updateFrames(activeExecutionStack);
        this.myListenersEnabled = true;
    }

    private void updateFrames(XExecutionStack executionStack) {
        if (this.mySelectedStack == executionStack) {
            return;
        }
        if (this.mySelectedStack != null) {
            this.getOrCreateBuilder(this.mySelectedStack).stop();
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            StackFramesListBuilder builder = this.getOrCreateBuilder(executionStack);
            builder.initModel(this.myFramesList.getModel());
            builder.start();
            XStackFrame topFrame = executionStack.getTopFrame();
            if (topFrame != null) {
                this.myFramesList.setSelectedValue(topFrame, true);
                this.onFrameSelected(executionStack, topFrame);
            }
        }
    }

    public void dispose() {
    }

    public XDebuggerFramesList getFramesList() {
        return this.myFramesList;
    }

    private void onFrameSelected(XExecutionStack executionStack, @NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/frame/XFramesView", "onFrameSelected"));
        }
        this.mySession.setCurrentStackFrame(executionStack, stackFrame);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void processFrameSelection() {
        if (!this.myListenersEnabled) {
            return;
        }
        Object selected = this.myFramesList.getSelectedValue();
        if (selected instanceof XStackFrame) {
            this.onFrameSelected(this.mySelectedStack, (XStackFrame)selected);
        }
    }

    private class StackFramesListBuilder
    implements XExecutionStack.XStackFrameContainer {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex;
        private boolean myRunning;
        private boolean myAllFramesLoaded;

        private StackFramesListBuilder(XExecutionStack executionStack) {
            this.myExecutionStack = executionStack;
            this.myStackFrames = new ArrayList<XStackFrame>();
            XStackFrame topFrame = executionStack.getTopFrame();
            if (topFrame != null) {
                this.myStackFrames.add(topFrame);
            }
            this.myNextFrameIndex = 1;
        }

        public void addStackFrames(final @NotNull List<? extends XStackFrame> stackFrames, final boolean last) {
            if (stackFrames == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "addStackFrames"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackFramesListBuilder.this.myStackFrames.addAll(stackFrames);
                    StackFramesListBuilder.this.addFrameListElements(stackFrames, last);
                    StackFramesListBuilder.this.myNextFrameIndex += stackFrames.size();
                    StackFramesListBuilder.this.myAllFramesLoaded = last;
                    if (last) {
                        StackFramesListBuilder.this.myRunning = false;
                    }
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "errorOccurred"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (StackFramesListBuilder.this.myErrorMessage == null) {
                        StackFramesListBuilder.this.myErrorMessage = errorMessage;
                        StackFramesListBuilder.this.addFrameListElements(Collections.singletonList(errorMessage), true);
                        StackFramesListBuilder.this.myRunning = false;
                    }
                }
            });
        }

        private void addFrameListElements(List<?> values, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                DefaultListModel model = XFramesView.this.myFramesList.getModel();
                if (model.getElementAt(model.getSize() - 1) == null) {
                    model.removeElementAt(model.getSize() - 1);
                }
                for (Object value : values) {
                    model.addElement(value);
                }
                if (!last) {
                    model.addElement(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void dispose() {
            this.myRunning = false;
            this.myExecutionStack = null;
        }

        public void start() {
            if (this.myExecutionStack == null || this.myErrorMessage != null) {
                return;
            }
            this.myRunning = true;
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
        }

        public void stop() {
            this.myRunning = false;
        }

        public void initModel(DefaultListModel model) {
            model.removeAllElements();
            for (XStackFrame stackFrame : this.myStackFrames) {
                model.addElement(stackFrame);
            }
            if (this.myErrorMessage != null) {
                model.addElement(this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model.addElement(null);
            }
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item;
            if (!XFramesView.this.myListenersEnabled) {
                return;
            }
            if (e.getStateChange() == 1 && (item = e.getItem()) instanceof XExecutionStack) {
                XFramesView.this.updateFrames((XExecutionStack)item);
            }
        }
    }
}

