/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.impl.frame.XDebugView;
import org.jetbrains.annotations.NotNull;

public class XDebugViewSessionListener
extends XDebugSessionAdapter {
    private XDebugView myDebugView;
    private final Project myProject;

    public XDebugViewSessionListener(@NotNull XDebugView debugView, @NotNull Project project) {
        if (debugView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "<init>"));
        }
        this.myDebugView = debugView;
        this.myProject = project;
    }

    private void onSessionEvent(final @NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "onSessionEvent"));
        }
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, new Runnable(){

            @Override
            public void run() {
                XDebugViewSessionListener.this.myDebugView.processSessionEvent(event);
            }
        });
    }

    public void sessionPaused() {
        this.onSessionEvent(XDebugView.SessionEvent.PAUSED);
    }

    public void sessionResumed() {
        this.onSessionEvent(XDebugView.SessionEvent.RESUMED);
    }

    public void sessionStopped() {
        this.onSessionEvent(XDebugView.SessionEvent.STOPPED);
    }

    public void stackFrameChanged() {
        this.onSessionEvent(XDebugView.SessionEvent.FRAME_CHANGED);
    }

    public void beforeSessionResume() {
        this.onSessionEvent(XDebugView.SessionEvent.BEFORE_RESUME);
    }
}

