/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPopup;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(AbstractValueHint.class);
    private static final TextAttributes ourReferenceAttributes = new TextAttributes();
    private final KeyListener myEditorKeyListener;
    private RangeHighlighter myHighlighter;
    private Cursor myStoredCursor;
    private final Project myProject;
    private final Editor myEditor;
    private final ValueHintType myType;
    private final Point myPoint;
    private LightweightHint myCurrentHint;
    private boolean myHintHidden;
    private TextRange myCurrentRange;
    private Runnable myHideRunnable;

    public AbstractValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!AbstractValueHint.isAltMask(e.getModifiers())) {
                    ValueLookupManager.getInstance(AbstractValueHint.this.myProject).hideHint();
                }
            }
        };
        this.myPoint = point;
        this.myProject = project;
        this.myEditor = editor;
        this.myType = type;
        this.myCurrentRange = textRange;
    }

    protected abstract boolean canShowHint();

    protected abstract void evaluateAndShowHint();

    public boolean isKeepHint(Editor editor, Point point) {
        if (this.myCurrentHint != null && this.myCurrentHint.canControlAutoHide()) {
            return true;
        }
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            return false;
        }
        if (this.myType == ValueHintType.MOUSE_CLICK_HINT) {
            if (this.myCurrentHint != null && this.myCurrentHint.isVisible()) {
                return true;
            }
        } else {
            int offset = AbstractValueHint.calculateOffset(editor, point);
            if (this.myCurrentRange != null && this.myCurrentRange.getStartOffset() <= offset && offset <= this.myCurrentRange.getEndOffset()) {
                return true;
            }
        }
        return false;
    }

    public static int calculateOffset(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "calculateOffset"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "calculateOffset"));
        }
        return editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
    }

    public void hideHint() {
        this.myHintHidden = true;
        this.myCurrentRange = null;
        if (this.myStoredCursor != null) {
            JComponent internalComponent = this.myEditor.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(myStoredCursor)");
            }
            internalComponent.removeKeyListener(this.myEditorKeyListener);
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
            this.myCurrentHint = null;
        }
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    public void invokeHint(Runnable hideRunnable) {
        this.myHideRunnable = hideRunnable;
        if (!this.canShowHint()) {
            this.hideHint();
            return;
        }
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), 6001, ourReferenceAttributes, HighlighterTargetArea.EXACT_RANGE);
            JComponent internalComponent = this.myEditor.getContentComponent();
            this.myStoredCursor = internalComponent.getCursor();
            internalComponent.addKeyListener(this.myEditorKeyListener);
            internalComponent.setCursor(AbstractValueHint.hintCursor());
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(hintCursor())");
            }
        } else {
            this.evaluateAndShowHint();
        }
    }

    private static Cursor hintCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    protected ValueHintType getType() {
        return this.myType;
    }

    protected boolean showHint(JComponent component) {
        this.myCurrentHint = new LightweightHint(component);
        this.myCurrentHint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                if (AbstractValueHint.this.myHideRunnable != null) {
                    AbstractValueHint.this.myHideRunnable.run();
                }
            }
        });
        if (this.myEditor.isDisposed() || this.myEditor.getComponent().getRootPane() == null) {
            return false;
        }
        Point p = HintManagerImpl.getHintPosition(this.myCurrentHint, this.myEditor, this.myEditor.xyToLogicalPosition(this.myPoint), (short)2);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myCurrentHint, this.myEditor, p, 42, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, this.myCurrentHint, (short)2, true));
        return true;
    }

    protected boolean isHintHidden() {
        return this.myHintHidden;
    }

    protected JComponent createExpandableHintComponent(SimpleColoredText text, final Runnable expand) {
        JComponent component = HintUtil.createInformationLabel(text, IconUtil.getAddIcon());
        AbstractValueHint.addClickListenerToHierarchy(component, new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$3", "onClick"));
                }
                if (AbstractValueHint.this.myCurrentHint != null) {
                    AbstractValueHint.this.myCurrentHint.hide();
                }
                expand.run();
                return true;
            }
        });
        return component;
    }

    private static void addClickListenerToHierarchy(Component c, ClickListener l) {
        l.installOn(c);
        if (c instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)c).getComponents()) {
                AbstractValueHint.addClickListenerToHierarchy(child, l);
            }
        }
    }

    protected TextRange getCurrentRange() {
        return this.myCurrentRange;
    }

    private static boolean isAltMask(@JdkConstants.InputEventMask int modifiers) {
        return modifiers == 8;
    }

    public static ValueHintType getType(EditorMouseEvent e) {
        return AbstractValueHint.isAltMask(e.getMouseEvent().getModifiers()) ? ValueHintType.MOUSE_ALT_OVER_HINT : ValueHintType.MOUSE_OVER_HINT;
    }

    public boolean isInsideHint(Editor editor, Point point) {
        return this.myCurrentHint != null && this.myCurrentHint.isInsideHint(new RelativePoint((Component)editor.getContentComponent(), point));
    }

    protected <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D descriptor) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "showTreePopup"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "showTreePopup"));
        }
        DebuggerTreeWithHistoryPopup.showTreePopup(creator, descriptor, this.getEditor(), this.myPoint, this.getProject());
    }

    static {
        ourReferenceAttributes.setForegroundColor((Color)JBColor.BLUE);
        ourReferenceAttributes.setEffectColor((Color)JBColor.BLUE);
        ourReferenceAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
    }
}

