/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(XValueHint.class);
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession myDebugSession;
    private final String myExpression;
    private final String myValueName;
    @Nullable
    private final XSourcePosition myExpressionPosition;

    public XValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSession session) {
        LanguageConsoleImpl console;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        super(project, editor, point, type, expressionInfo.getTextRange());
        this.myEvaluator = evaluator;
        this.myDebugSession = session;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText(expressionInfo, editor.getDocument());
        ConsoleView consoleView = (ConsoleView)ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW.get((UserDataHolder)editor);
        VirtualFile file = consoleView instanceof LanguageConsoleView ? ((console = ((LanguageConsoleView)consoleView).getConsole()).getHistoryViewer() == editor ? console.getVirtualFile() : null) : FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file != null ? XDebuggerUtil.getInstance().createPositionByOffset(file, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    @Override
    protected boolean canShowHint() {
        return true;
    }

    @Override
    protected void evaluateAndShowHint() {
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "evaluated"));
                }
                result.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;

                    @Override
                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1", "applyPresentation"));
                        }
                        if (XValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text = new SimpleColoredText();
                        text.append(XValueHint.this.myValueName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        XValueNodeImpl.buildText(valuePresenter, (ColoredTextContainer)text);
                        if (!hasChildren) {
                            SimpleColoredComponent component = HintUtil.createInformationComponent();
                            text.appendToComponent((ColoredTextContainer)component);
                            if (this.myFullValueEvaluator != null) {
                                component.append(this.myFullValueEvaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, (Object)new Consumer<MouseEvent>(){

                                    public void consume(MouseEvent event) {
                                        DebuggerUIUtil.showValuePopup(myFullValueEvaluator, event, XValueHint.this.getProject(), XValueHint.this.getEditor());
                                    }
                                });
                                LinkMouseListenerBase.installSingleTagOn(component);
                            }
                            XValueHint.this.showHint((JComponent)component);
                        } else if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            XValueHint.this.showTree(result);
                        } else {
                            JComponent component = XValueHint.this.createExpandableHintComponent(text, new Runnable(){

                                @Override
                                public void run() {
                                    XValueHint.this.showTree(result);
                                }
                            });
                            XValueHint.this.showHint(component);
                        }
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1", "setFullValueEvaluator"));
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return XValueHint.this.isHintHidden();
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "errorOccurred"));
                }
                LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
            }
        }, this.myExpressionPosition);
    }

    private void showTree(@NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "showTree"));
        }
        XValueMarkers<?, ?> valueMarkers = ((XDebugSessionImpl)this.myDebugSession).getValueMarkers();
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.myDebugSession.getProject(), this.myDebugSession.getDebugProcess().getEditorsProvider(), this.myDebugSession.getCurrentPosition(), valueMarkers);
        this.showTreePopup(creator, Pair.create((Object)value, (Object)this.myValueName));
    }
}

