/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XQuickEvaluateHandler
extends QuickEvaluateHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler");

    @Override
    public boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "isEnabled"));
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null && session.getDebugProcess().getEvaluator() != null;
    }

    @Override
    public AbstractValueHint createValueHint(final @NotNull Project project, final @NotNull Editor editor, final @NotNull Point point, final ValueHintType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "createValueHint"));
        }
        final XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null) {
            return null;
        }
        final XDebuggerEvaluator evaluator = session.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return null;
        }
        return (AbstractValueHint)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction((Computable)new Computable<XValueHint>(){

            public XValueHint compute() {
                int offset = AbstractValueHint.calculateOffset(editor, point);
                ExpressionInfo expressionInfo = XQuickEvaluateHandler.getExpressionInfo(evaluator, project, type, editor, offset);
                if (expressionInfo == null) {
                    return null;
                }
                int textLength = editor.getDocument().getTextLength();
                TextRange range = expressionInfo.getTextRange();
                if (range.getStartOffset() > range.getEndOffset() || range.getStartOffset() < 0 || range.getEndOffset() > textLength) {
                    LOG.error("invalid range: " + range + ", text length = " + textLength + ", evaluator: " + evaluator);
                    return null;
                }
                return new XValueHint(project, editor, point, type, expressionInfo, evaluator, session);
            }
        });
    }

    @Nullable
    private static ExpressionInfo getExpressionInfo(XDebuggerEvaluator evaluator, Project project, ValueHintType type, Editor editor, int offset) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            return new ExpressionInfo(new TextRange(selectionStart, selectionEnd));
        }
        return evaluator.getExpressionInfoAtOffset(project, editor.getDocument(), offset, false);
    }

    @Override
    public boolean canShowHint(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler", "canShowHint"));
        }
        return this.isEnabled(project);
    }

    @Override
    public int getValueLookupDelay(Project project) {
        XDebuggerEvaluator evaluator;
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session != null && (evaluator = session.getDebugProcess().getEvaluator()) != null) {
            return evaluator.getValuePopupDelay();
        }
        return 700;
    }
}

