/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import javax.swing.JTree;

class BreakpointsTreeCellRenderer {
    BreakpointsTreeCellRenderer() {
    }

    private static void customizeRenderer(Project project, Object value, boolean selected, boolean expanded, ColoredTreeCellRenderer renderer) {
        if (value instanceof BreakpointItemNode) {
            BreakpointItemNode node = (BreakpointItemNode)((Object)value);
            BreakpointItem breakpoint = node.getBreakpointItem();
            breakpoint.setupRenderer(renderer, project, selected);
        } else if (value instanceof BreakpointsGroupNode) {
            Object group = ((BreakpointsGroupNode)((Object)value)).getGroup();
            renderer.setIcon(group.getIcon(expanded));
            renderer.append(group.getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        }
    }

    public static class BreakpointsSimpleTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Project myProject;

        public BreakpointsSimpleTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value, selected, expanded, this);
        }
    }

    public static class BreakpointsCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Project myProject;

        public BreakpointsCheckboxTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value, selected, expanded, this.getTextRenderer());
        }
    }
}

