/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.DefaultConditionComboBoxPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointActionsPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XDebuggerComboBoxProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.XMasterBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XSuspendPolicyPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XLightBreakpointPropertiesPanel<B extends XBreakpoint<?>>
implements XSuspendPolicyPanel.Delegate {
    private boolean myShowMoreOptions;
    private JPanel myConditionExpressionPanel;
    private JPanel myConditionPanel;
    private JPanel myMainPanel;
    private Delegate myDelegate;
    private XSuspendPolicyPanel<B> mySuspendPolicyPanel;
    private XBreakpointActionsPanel<B> myActionsPanel;
    private XMasterBreakpointPanel<B> myMasterBreakpointPanel;
    private JPanel myCustomPropertiesPanelWrapper;
    private JPanel myCustomConditionsPanelWrapper;
    private JCheckBox myEnabledCheckbox;
    private JPanel myCustomRightPropertiesPanelWrapper;
    private final List<XBreakpointCustomPropertiesPanel<B>> myCustomPanels;
    private List<XBreakpointPropertiesSubPanel<B>> mySubPanels;
    private B myBreakpoint;

    public boolean showMoreOptions() {
        return this.myShowMoreOptions;
    }

    @Override
    public void showMoreOptionsIfNeeded() {
        if (this.myShowMoreOptions && this.myDelegate != null) {
            this.myDelegate.showMoreOptions();
        }
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointPanel.setDetailView(detailView);
    }

    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManager breakpointManager, B breakpoint, boolean showAllOptions) {
        XBreakpointCustomPropertiesPanel customRightConditionPanel;
        XBreakpointCustomPropertiesPanel customConditionPanel;
        this.$$$setupUI$$$();
        this.mySubPanels = new ArrayList<XBreakpointPropertiesSubPanel<B>>();
        this.myBreakpoint = breakpoint;
        XBreakpointType<B, ?> breakpointType = XBreakpointUtil.getType(breakpoint);
        this.mySuspendPolicyPanel.init(project, breakpointManager, breakpoint);
        this.mySuspendPolicyPanel.setDelegate(this);
        this.mySubPanels.add(this.mySuspendPolicyPanel);
        this.myMasterBreakpointPanel.init(project, breakpointManager, breakpoint);
        this.mySubPanels.add(this.myMasterBreakpointPanel);
        XDebuggerEditorsProvider debuggerEditorsProvider = breakpointType.getEditorsProvider(breakpoint, project);
        this.myActionsPanel.init(project, breakpointManager, breakpoint, debuggerEditorsProvider);
        this.mySubPanels.add(this.myActionsPanel);
        this.myCustomPanels = new ArrayList<XBreakpointCustomPropertiesPanel<B>>();
        if (debuggerEditorsProvider != null) {
            final DefaultConditionComboBoxPanel conditionPanel = debuggerEditorsProvider instanceof XDebuggerComboBoxProvider ? ((XDebuggerComboBoxProvider)debuggerEditorsProvider).createConditionComboBoxPanel(project, debuggerEditorsProvider, "breakpointCondition", this.myBreakpoint.getSourcePosition()) : new DefaultConditionComboBoxPanel(project, debuggerEditorsProvider, this.myBreakpoint.getSourcePosition());
            this.myConditionExpressionPanel.add((Component)conditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(conditionPanel);
            this.myMainPanel.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    IdeFocusManager.findInstance().requestFocus((Component)conditionPanel.getComponent(), false);
                }
            });
        } else {
            this.myConditionPanel.setVisible(false);
        }
        this.myShowMoreOptions = false;
        for (XBreakpointPropertiesSubPanel<B> panel : this.mySubPanels) {
            if (!panel.lightVariant(showAllOptions)) continue;
            this.myShowMoreOptions = true;
        }
        XBreakpointCustomPropertiesPanel customPropertiesPanel = breakpointType.createCustomPropertiesPanel();
        if (customPropertiesPanel != null) {
            this.myCustomPropertiesPanelWrapper.add((Component)customPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customPropertiesPanel);
        }
        if ((customConditionPanel = breakpointType.createCustomConditionsPanel()) != null) {
            this.myCustomConditionsPanelWrapper.add((Component)customConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customConditionPanel);
        }
        if ((customRightConditionPanel = breakpointType.createCustomRightPropertiesPanel(project)) != null && (showAllOptions || customRightConditionPanel.isVisibleOnPopup(breakpoint))) {
            this.myCustomRightPropertiesPanelWrapper.add((Component)customRightConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customRightConditionPanel);
        }
        this.myEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                XLightBreakpointPropertiesPanel.this.myBreakpoint.setEnabled(XLightBreakpointPropertiesPanel.this.myEnabledCheckbox.isSelected());
            }
        });
    }

    public void saveProperties() {
        for (XBreakpointPropertiesSubPanel<B> xBreakpointPropertiesSubPanel : this.mySubPanels) {
            xBreakpointPropertiesSubPanel.saveProperties();
        }
        for (XBreakpointCustomPropertiesPanel xBreakpointCustomPropertiesPanel : this.myCustomPanels) {
            xBreakpointCustomPropertiesPanel.saveTo(this.myBreakpoint);
        }
        this.myBreakpoint.setEnabled(this.myEnabledCheckbox.isSelected());
    }

    public void loadProperties() {
        for (XBreakpointPropertiesSubPanel<B> xBreakpointPropertiesSubPanel : this.mySubPanels) {
            xBreakpointPropertiesSubPanel.loadProperties();
        }
        for (XBreakpointCustomPropertiesPanel xBreakpointCustomPropertiesPanel : this.myCustomPanels) {
            xBreakpointCustomPropertiesPanel.loadFrom(this.myBreakpoint);
        }
        this.myEnabledCheckbox.setSelected(this.myBreakpoint.isEnabled());
        this.myEnabledCheckbox.setText(XBreakpointUtil.getShortText(this.myBreakpoint) + " enabled");
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        this.myActionsPanel.dispose();
        for (XBreakpointCustomPropertiesPanel<B> panel : this.myCustomPanels) {
            panel.dispose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myMainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConditionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Condition");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myConditionExpressionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        XSuspendPolicyPanel xSuspendPolicyPanel = new XSuspendPolicyPanel();
        this.mySuspendPolicyPanel = xSuspendPolicyPanel;
        JComponent jComponent = xSuspendPolicyPanel.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        XBreakpointActionsPanel xBreakpointActionsPanel = new XBreakpointActionsPanel();
        this.myActionsPanel = xBreakpointActionsPanel;
        JComponent jComponent2 = xBreakpointActionsPanel.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        XMasterBreakpointPanel xMasterBreakpointPanel = new XMasterBreakpointPanel();
        this.myMasterBreakpointPanel = xMasterBreakpointPanel;
        JComponent jComponent3 = xMasterBreakpointPanel.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCustomPropertiesPanelWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(8, 0, 1, 2, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myCustomConditionsPanelWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enabled");
        Font font = jCheckBox.getFont();
        jCheckBox.setFont(new Font(font.getName(), 1, 11));
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomRightPropertiesPanelWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setVisible(true);
        ((Component)jPanel).setEnabled(true);
        jPanel6.add((Component)jPanel, new GridConstraints(4, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface Delegate {
        public void showMoreOptions();
    }
}

