/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.DefaultLogExpressionComboBoxPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XDebuggerComboBoxProvider;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointActionsPanel<B extends XBreakpoint<?>>
extends XBreakpointPropertiesSubPanel<B> {
    private JCheckBox myLogMessageCheckBox;
    private JCheckBox myLogExpressionCheckBox;
    private JPanel myLogExpressionPanel;
    private JPanel myContentPane;
    private JPanel myMainPanel;
    private JCheckBox myTemporaryCheckBox;
    XBreakpointCustomPropertiesPanel<B> logExpressionPanel;

    public XBreakpointActionsPanel() {
        this.$$$setupUI$$$();
    }

    public void init(Project project, XBreakpointManager breakpointManager, @NotNull B breakpoint, @Nullable XDebuggerEditorsProvider debuggerEditorsProvider) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointActionsPanel", "init"));
        }
        this.init(project, breakpointManager, breakpoint);
        if (debuggerEditorsProvider != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XBreakpointActionsPanel.this.onCheckboxChanged();
                }
            };
            this.logExpressionPanel = debuggerEditorsProvider instanceof XDebuggerComboBoxProvider ? ((XDebuggerComboBoxProvider)debuggerEditorsProvider).createLogExpressionComboBoxPanel(project, debuggerEditorsProvider, "breakpointLogExpression", this.myBreakpoint.getSourcePosition()) : new DefaultLogExpressionComboBoxPanel(project, debuggerEditorsProvider, this.myBreakpoint.getSourcePosition());
            JComponent logExpressionComponent = this.logExpressionPanel.getComponent();
            this.myLogExpressionPanel.add((Component)logExpressionComponent, "Center");
            logExpressionComponent.setEnabled(false);
            this.myTemporaryCheckBox.setVisible(breakpoint instanceof XLineBreakpoint);
            this.myLogExpressionCheckBox.addActionListener(listener);
            DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, logExpressionComponent);
        } else {
            this.myLogExpressionCheckBox.setVisible(false);
        }
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        if (!(showAllOptions || this.myBreakpoint.isLogMessage() || this.myBreakpoint.getLogExpression() != null || this.myBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myBreakpoint).isTemporary())) {
            this.myMainPanel.setVisible(false);
            return true;
        }
        this.myMainPanel.setBorder(null);
        return false;
    }

    private void onCheckboxChanged() {
        if (this.logExpressionPanel != null) {
            this.logExpressionPanel.getComponent().setEnabled(this.myLogExpressionCheckBox.isSelected());
        }
    }

    @Override
    void loadProperties() {
        this.myLogMessageCheckBox.setSelected(this.myBreakpoint.isLogMessage());
        if (this.myBreakpoint instanceof XLineBreakpoint) {
            this.myTemporaryCheckBox.setSelected(((XLineBreakpoint)this.myBreakpoint).isTemporary());
        }
        if (this.logExpressionPanel != null) {
            this.myLogExpressionCheckBox.setSelected(this.myBreakpoint.getLogExpression() != null);
            this.logExpressionPanel.loadFrom(this.myBreakpoint);
        }
        this.onCheckboxChanged();
    }

    @Override
    void saveProperties() {
        this.myBreakpoint.setLogMessage(this.myLogMessageCheckBox.isSelected());
        if (this.myBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myBreakpoint).setTemporary(this.myTemporaryCheckBox.isSelected());
        }
        if (this.logExpressionPanel != null) {
            this.logExpressionPanel.saveTo(this.myBreakpoint);
        }
    }

    public void dispose() {
        if (this.logExpressionPanel != null) {
            this.logExpressionPanel.dispose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.properties.actions.group.title"), (int)0, (int)0, null, null));
        this.myLogMessageCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.message.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLogExpressionCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoints.log.expression.checkbox"));
        ((Component)jCheckBox2).setEnabled(true);
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLogExpressionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myTemporaryCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remove once hit");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

