/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsCheckboxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsDialog
extends DialogWrapper {
    @NotNull
    private Project myProject;
    private Object myInitialBreakpoint;
    private List<BreakpointPanelProvider> myBreakpointsPanelProviders;
    private BreakpointItemsTreeController myTreeController;
    JLabel temp;
    private MasterController myMasterController;
    private final DetailController myDetailController;
    private Collection<BreakpointItem> myBreakpointItems;
    private final List<XBreakpointGroupingRule> myRulesAvailable;
    private Set<XBreakpointGroupingRule> myRulesEnabled;
    private Disposable myListenerDisposable;
    private List<ToggleActionButton> myToggleRuleActions;

    private XBreakpointManagerImpl getBreakpointManager() {
        return (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    protected BreakpointsDialog(@NotNull Project project, Object breakpoint, @NotNull List<BreakpointPanelProvider> providers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog", "<init>"));
        }
        super(project);
        this.temp = new JLabel();
        this.myMasterController = new MasterController(){

            @Override
            public ItemWrapper[] getSelectedItems() {
                List<BreakpointItem> res = BreakpointsDialog.this.myTreeController.getSelectedBreakpoints();
                return res.toArray(new ItemWrapper[res.size()]);
            }

            @Override
            public JLabel getPathLabel() {
                return BreakpointsDialog.this.temp;
            }
        };
        this.myDetailController = new DetailController(this.myMasterController);
        this.myBreakpointItems = new ArrayList<BreakpointItem>();
        this.myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
        this.myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(new Comparator<XBreakpointGroupingRule>(){

            @Override
            public int compare(XBreakpointGroupingRule o1, XBreakpointGroupingRule o2) {
                int res = o2.getPriority() - o1.getPriority();
                return res != 0 ? res : o1.getId().compareTo(o2.getId());
            }
        });
        this.myListenerDisposable = Disposer.newDisposable();
        this.myToggleRuleActions = new ArrayList<ToggleActionButton>();
        this.myProject = project;
        this.myBreakpointsPanelProviders = providers;
        this.myInitialBreakpoint = breakpoint;
        this.collectGroupingRules();
        this.collectItems();
        this.setTitle("Breakpoints");
        this.setModal(false);
        this.init();
        this.setOKButtonText("Done");
    }

    private String getSplitterProportionKey() {
        return this.getDimensionServiceKey() + ".splitter";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBSplitter splitPane = new JBSplitter(0.3f);
        splitPane.setSplitterProportionKey(this.getSplitterProportionKey());
        splitPane.setFirstComponent(this.createMasterView());
        splitPane.setSecondComponent(this.createDetailView());
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JComponent createDetailView() {
        DetailViewImpl detailView = new DetailViewImpl(this.myProject);
        this.myDetailController.setDetailView(detailView);
        return detailView;
    }

    void collectItems() {
        if (!this.myBreakpointsPanelProviders.isEmpty()) {
            this.disposeItems();
            this.myBreakpointItems.clear();
            for (BreakpointPanelProvider panelProvider : this.myBreakpointsPanelProviders) {
                panelProvider.provideBreakpointItems(this.myProject, this.myBreakpointItems);
            }
        }
    }

    void initSelection(Collection<BreakpointItem> breakpoints) {
        boolean found = false;
        for (BreakpointItem breakpoint : breakpoints) {
            if (breakpoint.getBreakpoint() != this.myInitialBreakpoint) continue;
            this.myTreeController.selectBreakpointItem(breakpoint, null);
            found = true;
            break;
        }
        if (!found && !breakpoints.isEmpty()) {
            this.myTreeController.selectFirstBreakpointItem();
        }
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog", "createActions"));
        }
        return actionArray;
    }

    private JComponent createMasterView() {
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesEnabled){

            @Override
            public void nodeStateWillChangeImpl(CheckedTreeNode node) {
                if (node instanceof BreakpointItemNode) {
                    ((BreakpointItemNode)node).getBreakpointItem().saveState();
                }
                super.nodeStateWillChangeImpl(node);
            }

            @Override
            public void nodeStateDidChangeImpl(CheckedTreeNode node) {
                super.nodeStateDidChangeImpl(node);
                if (node instanceof BreakpointItemNode) {
                    BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
                }
            }

            @Override
            protected void selectionChangedImpl() {
                super.selectionChangedImpl();
                BreakpointsDialog.this.saveCurrentItem();
                BreakpointsDialog.this.myDetailController.updateDetailView();
            }
        };
        BreakpointsCheckboxTree tree = new BreakpointsCheckboxTree(this.myProject, this.myTreeController){

            protected void onDoubleClick(CheckedTreeNode node) {
                BreakpointsDialog.this.navigate(false);
            }
        };
        new AnAction("BreakpointDialog.GoToSource"){

            public void actionPerformed(AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)), (JComponent)((Object)tree));
        new AnAction("BreakpointDialog.ShowSource"){

            public void actionPerformed(AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)((Object)tree));
        final DefaultActionGroup breakpointTypes = new DefaultActionGroup();
        for (BreakpointPanelProvider provider : this.myBreakpointsPanelProviders) {
            breakpointTypes.addAll(provider.getAddBreakpointActions(this.myProject));
        }
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)tree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)breakpointTypes, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.NUMBERING, false).show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BreakpointsDialog.this.myTreeController.removeSelectedBreakpoints(BreakpointsDialog.this.myProject);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                ItemWrapper[] items;
                boolean enabled = false;
                for (ItemWrapper item : items = BreakpointsDialog.this.myMasterController.getSelectedItems()) {
                    if (!item.allowedToRemove()) continue;
                    enabled = true;
                }
                return enabled;
            }
        }).setToolbarPosition(ActionToolbarPosition.TOP).setToolbarBorder(IdeBorderFactory.createEmptyBorder());
        ((JComponent)((Object)tree)).setBorder(IdeBorderFactory.createBorder());
        for (ToggleActionButton action : this.myToggleRuleActions) {
            decorator.addExtraAction((AnActionButton)action);
        }
        JPanel decoratedTree = decorator.createPanel();
        decoratedTree.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myTreeController.setTreeView((JTree)((Object)tree));
        this.myTreeController.buildTree(this.myBreakpointItems);
        this.initSelection(this.myBreakpointItems);
        BreakpointPanelProvider.BreakpointsListener listener = new BreakpointPanelProvider.BreakpointsListener(){

            @Override
            public void breakpointsChanged() {
                BreakpointsDialog.this.collectItems();
                BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
                BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
            }
        };
        for (BreakpointPanelProvider provider : this.myBreakpointsPanelProviders) {
            provider.addListener(listener, this.myProject, this.myListenerDisposable);
        }
        return decoratedTree;
    }

    private void navigate(boolean requestFocus) {
        List<BreakpointItem> breakpoints = this.myTreeController.getSelectedBreakpoints();
        if (!breakpoints.isEmpty()) {
            breakpoints.get(0).navigate(requestFocus);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeController.getTreeView();
    }

    private void collectGroupingRules() {
        for (BreakpointPanelProvider provider : this.myBreakpointsPanelProviders) {
            provider.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.myRulesEnabled.clear();
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains(rule.getId()))) continue;
            this.myRulesEnabled.add(rule);
        }
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (rule.isAlwaysEnabled()) continue;
            this.myToggleRuleActions.add(new ToggleBreakpointGroupingRuleEnabledAction(rule));
        }
    }

    private void saveBreakpointsDialogState() {
        XBreakpointsDialogState dialogState = new XBreakpointsDialogState();
        List rulesEnabled = ContainerUtil.filter(this.myRulesEnabled, (Condition)new Condition<XBreakpointGroupingRule>(){

            public boolean value(XBreakpointGroupingRule rule) {
                return !rule.isAlwaysEnabled();
            }
        });
        dialogState.setSelectedGroupingRules((Set<String>)new HashSet((Collection)ContainerUtil.map((Collection)rulesEnabled, (Function)new Function<XBreakpointGroupingRule, String>(){

            public String fun(XBreakpointGroupingRule rule) {
                return rule.getId();
            }
        })));
        this.getBreakpointManager().setBreakpointsDialogSettings(dialogState);
    }

    protected void dispose() {
        this.saveCurrentItem();
        Disposer.dispose((Disposable)this.myListenerDisposable);
        this.saveBreakpointsDialogState();
        this.disposeItems();
        super.dispose();
    }

    private void disposeItems() {
        for (BreakpointItem item : this.myBreakpointItems) {
            item.dispose();
        }
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.breakpoints";
    }

    private void saveCurrentItem() {
        ItemWrapper item = this.myDetailController.getSelectedItem();
        if (item instanceof BreakpointItem) {
            ((BreakpointItem)item).saveState();
        }
    }

    private class ToggleBreakpointGroupingRuleEnabledAction
    extends ToggleActionButton {
        private XBreakpointGroupingRule myRule;

        public ToggleBreakpointGroupingRuleEnabledAction(XBreakpointGroupingRule rule) {
            super(rule.getPresentableName(), rule.getIcon());
            this.myRule = rule;
            this.getTemplatePresentation().setText(rule.getPresentableName());
        }

        public boolean isSelected(AnActionEvent e) {
            return BreakpointsDialog.this.myRulesEnabled.contains(this.myRule);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                BreakpointsDialog.this.myRulesEnabled.add(this.myRule);
            } else {
                BreakpointsDialog.this.myRulesEnabled.remove(this.myRule);
            }
            BreakpointsDialog.this.myTreeController.setGroupingRules(BreakpointsDialog.this.myRulesEnabled);
        }
    }
}

