/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Tag(value="breakpoint")
public class BreakpointState<B extends XBreakpoint<P>, P extends XBreakpointProperties, T extends XBreakpointType<B, P>> {
    private String myTypeId;
    private boolean myEnabled;
    private Element myPropertiesElement;
    private SuspendPolicy mySuspendPolicy = SuspendPolicy.ALL;
    private boolean myLogMessage;
    private LogExpression myLogExpression;
    private Condition myCondition;
    private XBreakpointDependencyState myDependencyState;
    private long myTimeStamp;

    public BreakpointState() {
    }

    public BreakpointState(boolean enabled, String typeId, long timeStamp) {
        this.myEnabled = enabled;
        this.myTypeId = typeId;
        this.myTimeStamp = timeStamp;
    }

    @Attribute(value="enabled")
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Attribute(value="type")
    public String getTypeId() {
        return this.myTypeId;
    }

    public void setTypeId(String typeId) {
        this.myTypeId = typeId;
    }

    @Tag(value="properties")
    public Element getPropertiesElement() {
        return this.myPropertiesElement;
    }

    public void setPropertiesElement(Element propertiesElement) {
        this.myPropertiesElement = propertiesElement;
    }

    @Attribute(value="suspend")
    public String getSuspendPolicyString() {
        return this.mySuspendPolicy.name();
    }

    public void setSuspendPolicyString(String suspendPolicy) {
        this.mySuspendPolicy = SuspendPolicy.valueOf((String)suspendPolicy);
    }

    @Transient
    public SuspendPolicy getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    public void setSuspendPolicy(SuspendPolicy suspendPolicy) {
        this.mySuspendPolicy = suspendPolicy;
    }

    @Attribute(value="log-message")
    public boolean isLogMessage() {
        return this.myLogMessage;
    }

    public void setLogMessage(boolean logMessage) {
        this.myLogMessage = logMessage;
    }

    @Transient
    public String getLogExpression() {
        return this.myLogExpression != null ? this.myLogExpression.myExpression : null;
    }

    public void setLogExpression(String expression) {
        if (expression != null) {
            this.myLogExpression = new LogExpression();
            this.myLogExpression.myExpression = expression;
        } else {
            this.myLogExpression = null;
        }
    }

    @Property(surroundWithTag=false)
    public LogExpression getLogExpressionObject() {
        return this.myLogExpression;
    }

    public void setLogExpressionObject(LogExpression logExpression) {
        this.setLogExpression(logExpression.myOldExpression != null ? logExpression.myOldExpression : logExpression.myExpression);
    }

    @Transient
    public String getCondition() {
        return this.myCondition != null ? this.myCondition.myExpression : null;
    }

    public void setCondition(String condition) {
        if (condition != null) {
            this.myCondition = new Condition();
            this.myCondition.myExpression = condition;
        } else {
            this.myCondition = null;
        }
    }

    @Property(surroundWithTag=false)
    public Condition getConditionObject() {
        return this.myCondition;
    }

    public void setConditionObject(Condition condition) {
        this.setCondition(condition.myOldExpression != null ? condition.myOldExpression : condition.myExpression);
    }

    @Property(surroundWithTag=false)
    public XBreakpointDependencyState getDependencyState() {
        return this.myDependencyState;
    }

    public void setDependencyState(XBreakpointDependencyState dependencyState) {
        this.myDependencyState = dependencyState;
    }

    public XBreakpointBase<B, P, ?> createBreakpoint(@NotNull T type, @NotNull XBreakpointManagerImpl breakpointManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/breakpoints/BreakpointState", "createBreakpoint"));
        }
        if (breakpointManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/breakpoints/BreakpointState", "createBreakpoint"));
        }
        return new XBreakpointBase(type, breakpointManager, this);
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    void applyDefaults(BreakpointState state) {
        state.mySuspendPolicy = this.mySuspendPolicy;
    }

    @Tag(value="log-expression")
    public static class LogExpression {
        @Attribute(value="expression")
        public String myExpression;
        @Text
        public String myOldExpression;
    }

    @Tag(value="condition")
    public static class Condition {
        @Attribute(value="expression")
        public String myExpression;
        @Text
        public String myOldExpression;
    }
}

