/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XDebuggerSmartStepIntoHandler
extends XDebuggerSuspendedActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler", "isEnabled"));
        }
        return super.isEnabled(session, dataContext) && session.getDebugProcess().getSmartStepIntoHandler() != null;
    }

    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler", "perform"));
        }
        XSmartStepIntoHandler handler = session.getDebugProcess().getSmartStepIntoHandler();
        XSourcePosition position = session.getCurrentPosition();
        if (position == null || handler == null) {
            return;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)session.getProject()).getSelectedEditor(position.getFile());
        if (!(editor instanceof TextEditor)) {
            return;
        }
        RelativePoint relativePoint = DebuggerUIUtil.calcPopupLocation(((TextEditor)editor).getEditor(), position.getLine());
        XDebuggerSmartStepIntoHandler.doSmartStepInto(handler, position, session, relativePoint);
    }

    private static <V extends XSmartStepIntoVariant> void doSmartStepInto(final XSmartStepIntoHandler<V> handler, XSourcePosition position, final XDebugSession session, RelativePoint relativePoint) {
        List variants = handler.computeSmartStepVariants(position);
        if (variants.isEmpty()) {
            session.stepInto();
            return;
        }
        if (variants.size() == 1) {
            session.smartStepInto(handler, (XSmartStepIntoVariant)variants.get(0));
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<V>(handler.getPopupTitle(position), variants){

            public Icon getIconFor(V aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(V value) {
                String string = value.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$1", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(V selectedValue, boolean finalChoice) {
                session.smartStepInto(handler, selectedValue);
                return FINAL_CHOICE;
            }
        }).show(relativePoint);
    }
}

