/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class EditBreakpointActionHandler
extends DebuggerActionHandler {
    protected abstract void doShowPopup(Project var1, JComponent var2, Point var3, Object var4);

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "perform"));
        }
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        Pair<GutterIconRenderer, Object> pair = XBreakpointUtil.findSelectedBreakpoint(project, editor);
        Object breakpoint = pair.second;
        GutterIconRenderer breakpointGutterRenderer = (GutterIconRenderer)pair.first;
        if (breakpointGutterRenderer == null) {
            return;
        }
        this.editBreakpoint(project, editor, breakpoint, breakpointGutterRenderer);
    }

    public void editBreakpoint(@NotNull Project project, @NotNull Editor editor, @NotNull Object breakpoint, @NotNull GutterIconRenderer breakpointGutterRenderer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpointGutterRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (BreakpointsDialogFactory.getInstance(project).isBreakpointPopupShowing()) {
            return;
        }
        EditorGutterComponentEx gutterComponent = ((EditorEx)editor).getGutterComponentEx();
        Point point = gutterComponent.getPoint(breakpointGutterRenderer);
        if (point == null) {
            return;
        }
        Icon icon = breakpointGutterRenderer.getIcon();
        Point whereToShow = new Point(point.x + icon.getIconWidth() / 2, point.y + icon.getIconHeight() / 2);
        this.doShowPopup(project, gutterComponent, whereToShow, breakpoint);
    }

    public void editBreakpoint(@NotNull Project project, @NotNull JComponent parent, @NotNull Point whereToShow, @NotNull BreakpointItem breakpoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (whereToShow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler", "editBreakpoint"));
        }
        this.doShowPopup(project, parent, whereToShow, breakpoint.getBreakpoint());
    }
}

