/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerEditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerMuteBreakpointsHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerPauseActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerRunToCursorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSmartStepIntoHandler;
import com.intellij.xdebugger.impl.actions.handlers.XEvaluateInConsoleFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XMarkObjectActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XToggleLineBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingsPanelProviderImpl;
import org.jetbrains.annotations.NotNull;

public class XDebuggerSupport
extends DebuggerSupport {
    private final XBreakpointPanelProvider myBreakpointPanelProvider;
    private final XToggleLineBreakpointActionHandler myToggleLineBreakpointActionHandler;
    private final XToggleLineBreakpointActionHandler myToggleTemporaryLineBreakpointActionHandler;
    private final XDebuggerSuspendedActionHandler myStepOverHandler;
    private final XDebuggerSuspendedActionHandler myStepIntoHandler;
    private final XDebuggerSuspendedActionHandler myStepOutHandler;
    private final XDebuggerSuspendedActionHandler myForceStepOverHandler;
    private final XDebuggerSuspendedActionHandler myForceStepIntoHandler;
    private final XDebuggerRunToCursorActionHandler myRunToCursorHandler;
    private final XDebuggerRunToCursorActionHandler myForceRunToCursor;
    private final XDebuggerActionHandler myResumeHandler;
    private final XDebuggerPauseActionHandler myPauseHandler;
    private final XDebuggerSuspendedActionHandler myShowExecutionPointHandler;
    private final XDebuggerEvaluateActionHandler myEvaluateHandler;
    private final XQuickEvaluateHandler myQuickEvaluateHandler;
    private final XDebuggerSettingsPanelProviderImpl mySettingsPanelProvider;
    private final XAddToWatchesFromEditorActionHandler myAddToWatchesActionHandler;
    private final DebuggerActionHandler myEvaluateInConsoleActionHandler = new XEvaluateInConsoleFromEditorActionHandler();
    private final DebuggerToggleActionHandler myMuteBreakpointsHandler;
    private final DebuggerActionHandler mySmartStepIntoHandler;
    private final XMarkObjectActionHandler myMarkObjectActionHandler;
    private final EditBreakpointActionHandler myEditBreakpointActionHandler;

    public XDebuggerSupport() {
        this.myBreakpointPanelProvider = new XBreakpointPanelProvider();
        this.myToggleLineBreakpointActionHandler = new XToggleLineBreakpointActionHandler(false);
        this.myToggleTemporaryLineBreakpointActionHandler = new XToggleLineBreakpointActionHandler(true);
        this.myAddToWatchesActionHandler = new XAddToWatchesFromEditorActionHandler();
        this.myStepOverHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$1", "perform"));
                }
                session.stepOver(false);
            }
        };
        this.myStepIntoHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$2", "perform"));
                }
                session.stepInto();
            }
        };
        this.myStepOutHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$3", "perform"));
                }
                session.stepOut();
            }
        };
        this.myForceStepOverHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$4", "perform"));
                }
                session.stepOver(true);
            }
        };
        this.myForceStepIntoHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$5", "perform"));
                }
                session.forceStepInto();
            }
        };
        this.mySmartStepIntoHandler = new XDebuggerSmartStepIntoHandler();
        this.myRunToCursorHandler = new XDebuggerRunToCursorActionHandler(false);
        this.myForceRunToCursor = new XDebuggerRunToCursorActionHandler(true);
        this.myResumeHandler = new XDebuggerActionHandler(){

            @Override
            protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$6", "isEnabled"));
                }
                return session.isPaused();
            }

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$6", "perform"));
                }
                session.resume();
            }
        };
        this.myPauseHandler = new XDebuggerPauseActionHandler();
        this.myShowExecutionPointHandler = new XDebuggerSuspendedActionHandler(){

            @Override
            protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport$7", "perform"));
                }
                session.showExecutionPoint();
            }
        };
        this.myMuteBreakpointsHandler = new XDebuggerMuteBreakpointsHandler();
        this.myEvaluateHandler = new XDebuggerEvaluateActionHandler();
        this.myQuickEvaluateHandler = new XQuickEvaluateHandler();
        this.mySettingsPanelProvider = new XDebuggerSettingsPanelProviderImpl();
        this.myMarkObjectActionHandler = new XMarkObjectActionHandler();
        this.myEditBreakpointActionHandler = new XDebuggerEditBreakpointActionHandler();
    }

    @Override
    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        XBreakpointPanelProvider xBreakpointPanelProvider = this.myBreakpointPanelProvider;
        if (xBreakpointPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getBreakpointPanelProvider"));
        }
        return xBreakpointPanelProvider;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOverHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myStepOverHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getStepOverHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepIntoHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myStepIntoHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getStepIntoHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getSmartStepIntoHandler() {
        DebuggerActionHandler debuggerActionHandler = this.mySmartStepIntoHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getSmartStepIntoHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOutHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myStepOutHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getStepOutHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepOverHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myForceStepOverHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getForceStepOverHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepIntoHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myForceStepIntoHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getForceStepIntoHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getRunToCursorHandler() {
        XDebuggerRunToCursorActionHandler xDebuggerRunToCursorActionHandler = this.myRunToCursorHandler;
        if (xDebuggerRunToCursorActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getRunToCursorHandler"));
        }
        return xDebuggerRunToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceRunToCursorHandler() {
        XDebuggerRunToCursorActionHandler xDebuggerRunToCursorActionHandler = this.myForceRunToCursor;
        if (xDebuggerRunToCursorActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getForceRunToCursorHandler"));
        }
        return xDebuggerRunToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getResumeActionHandler() {
        XDebuggerActionHandler xDebuggerActionHandler = this.myResumeHandler;
        if (xDebuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getResumeActionHandler"));
        }
        return xDebuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getPauseHandler() {
        XDebuggerPauseActionHandler xDebuggerPauseActionHandler = this.myPauseHandler;
        if (xDebuggerPauseActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getPauseHandler"));
        }
        return xDebuggerPauseActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleLineBreakpointHandler() {
        XToggleLineBreakpointActionHandler xToggleLineBreakpointActionHandler = this.myToggleLineBreakpointActionHandler;
        if (xToggleLineBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getToggleLineBreakpointHandler"));
        }
        return xToggleLineBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleTemporaryLineBreakpointHandler() {
        XToggleLineBreakpointActionHandler xToggleLineBreakpointActionHandler = this.myToggleTemporaryLineBreakpointActionHandler;
        if (xToggleLineBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getToggleTemporaryLineBreakpointHandler"));
        }
        return xToggleLineBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getShowExecutionPointHandler() {
        XDebuggerSuspendedActionHandler xDebuggerSuspendedActionHandler = this.myShowExecutionPointHandler;
        if (xDebuggerSuspendedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getShowExecutionPointHandler"));
        }
        return xDebuggerSuspendedActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        XDebuggerEvaluateActionHandler xDebuggerEvaluateActionHandler = this.myEvaluateHandler;
        if (xDebuggerEvaluateActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getEvaluateHandler"));
        }
        return xDebuggerEvaluateActionHandler;
    }

    @Override
    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        XQuickEvaluateHandler xQuickEvaluateHandler = this.myQuickEvaluateHandler;
        if (xQuickEvaluateHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getQuickEvaluateHandler"));
        }
        return xQuickEvaluateHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getAddToWatchesActionHandler() {
        XAddToWatchesFromEditorActionHandler xAddToWatchesFromEditorActionHandler = this.myAddToWatchesActionHandler;
        if (xAddToWatchesFromEditorActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getAddToWatchesActionHandler"));
        }
        return xAddToWatchesFromEditorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateInConsoleActionHandler() {
        DebuggerActionHandler debuggerActionHandler = this.myEvaluateInConsoleActionHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getEvaluateInConsoleActionHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerToggleActionHandler getMuteBreakpointsHandler() {
        DebuggerToggleActionHandler debuggerToggleActionHandler = this.myMuteBreakpointsHandler;
        if (debuggerToggleActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getMuteBreakpointsHandler"));
        }
        return debuggerToggleActionHandler;
    }

    @Override
    @NotNull
    public MarkObjectActionHandler getMarkObjectHandler() {
        XMarkObjectActionHandler xMarkObjectActionHandler = this.myMarkObjectActionHandler;
        if (xMarkObjectActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getMarkObjectHandler"));
        }
        return xMarkObjectActionHandler;
    }

    @Override
    public AbstractDebuggerSession getCurrentSession(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebuggerSupport", "getCurrentSession"));
        }
        return XDebuggerManager.getInstance((Project)project).getCurrentSession();
    }

    @Override
    @NotNull
    public EditBreakpointActionHandler getEditBreakpointAction() {
        EditBreakpointActionHandler editBreakpointActionHandler = this.myEditBreakpointActionHandler;
        if (editBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getEditBreakpointAction"));
        }
        return editBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerSettingsPanelProvider getSettingsPanelProvider() {
        XDebuggerSettingsPanelProviderImpl xDebuggerSettingsPanelProviderImpl = this.mySettingsPanelProvider;
        if (xDebuggerSettingsPanelProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerSupport", "getSettingsPanelProvider"));
        }
        return xDebuggerSettingsPanelProviderImpl;
    }
}

