/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionImpl
implements XDebugSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebugSessionImpl");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Debugger messages", (String)ToolWindowId.DEBUG, (boolean)false);
    private XDebugProcess myDebugProcess;
    private final Map<XBreakpoint<?>, CustomizedBreakpointPresentation> myRegisteredBreakpoints;
    private final Set<XBreakpoint<?>> myInactiveSlaveBreakpoints;
    private boolean myBreakpointsMuted;
    private boolean myBreakpointsDisabled;
    private final XDebuggerManagerImpl myDebuggerManager;
    private MyBreakpointListener myBreakpointListener;
    private XSuspendContext mySuspendContext;
    private XExecutionStack myCurrentExecutionStack;
    private XStackFrame myCurrentStackFrame;
    private XSourcePosition myCurrentPosition;
    private final AtomicBoolean myPaused;
    private MyDependentBreakpointListener myDependentBreakpointListener;
    private XValueMarkers<?, ?> myValueMarkers;
    private final String mySessionName;
    private XDebugSessionTab mySessionTab;
    private XDebugSessionData mySessionData;
    private XBreakpoint<?> myActiveNonLineBreakpoint;
    private final EventDispatcher<XDebugSessionListener> myDispatcher;
    private final Project myProject;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    private final ProgramRunner myRunner;
    private boolean myStopped;
    private boolean myPauseActionSupported;
    private boolean myShowTabOnSuspend;
    private final List<AnAction> myRestartActions;
    private ConsoleView myConsoleView;
    private final Icon myIcon;
    private volatile boolean breakpointsInitialized;
    private boolean autoInitBreakpoints;

    public XDebugSessionImpl(@NotNull ExecutionEnvironment env, @NotNull ProgramRunner runner, XDebuggerManagerImpl debuggerManager) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "<init>"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "<init>"));
        }
        this(env, runner, debuggerManager, env.getRunProfile().getName(), env.getRunProfile().getIcon(), false);
    }

    public XDebugSessionImpl(@Nullable ExecutionEnvironment env, @Nullable ProgramRunner runner, XDebuggerManagerImpl debuggerManager, @NotNull String sessionName, @Nullable Icon icon, boolean showTabOnSuspend) {
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/XDebugSessionImpl", "<init>"));
        }
        this.myRegisteredBreakpoints = new THashMap();
        this.myInactiveSlaveBreakpoints = new SmartHashSet();
        this.myPaused = new AtomicBoolean();
        this.myDispatcher = EventDispatcher.create(XDebugSessionListener.class);
        this.myRestartActions = new SmartList();
        this.autoInitBreakpoints = true;
        this.myEnvironment = env;
        this.myRunner = runner;
        this.mySessionName = sessionName;
        this.myDebuggerManager = debuggerManager;
        this.myShowTabOnSuspend = showTabOnSuspend;
        this.myProject = debuggerManager.getProject();
        ValueLookupManager.getInstance(this.myProject).startListening();
        this.myIcon = icon;
    }

    @NotNull
    public String getSessionName() {
        String string = this.mySessionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebugSessionImpl", "getSessionName"));
        }
        return string;
    }

    @NotNull
    public RunContentDescriptor getRunContentDescriptor() {
        this.assertSessionTabInitialized();
        RunContentDescriptor runContentDescriptor = this.mySessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebugSessionImpl", "getRunContentDescriptor"));
        }
        return runContentDescriptor;
    }

    private void assertSessionTabInitialized() {
        if (this.myShowTabOnSuspend) {
            LOG.error("Debug tool window isn't shown yet because debug process isn't suspended");
        } else {
            LOG.assertTrue(this.mySessionTab != null, (Object)"Debug tool window not initialized yet!");
        }
    }

    public void setAutoInitBreakpoints(boolean value) {
        this.autoInitBreakpoints = value;
    }

    public void setPauseActionSupported(boolean isSupported) {
        this.myPauseActionSupported = isSupported;
    }

    public List<AnAction> getRestartActions() {
        return this.myRestartActions;
    }

    public void addRestartActions(AnAction ... restartActions) {
        Collections.addAll(this.myRestartActions, restartActions);
    }

    public void rebuildViews() {
        if (!this.myShowTabOnSuspend && this.mySessionTab != null) {
            this.mySessionTab.rebuildViews();
        }
    }

    @Nullable
    public RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public boolean isPauseActionSupported() {
        return this.myPauseActionSupported;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDebuggerManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebugSessionImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public XDebugProcess getDebugProcess() {
        XDebugProcess xDebugProcess = this.myDebugProcess;
        if (xDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebugSessionImpl", "getDebugProcess"));
        }
        return xDebugProcess;
    }

    public boolean isSuspended() {
        return this.myPaused.get() && this.mySuspendContext != null;
    }

    public boolean isPaused() {
        return this.myPaused.get();
    }

    @Nullable
    public XStackFrame getCurrentStackFrame() {
        return this.myCurrentStackFrame;
    }

    public XSuspendContext getSuspendContext() {
        return this.mySuspendContext;
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        return this.myCurrentPosition;
    }

    public XDebugSessionTab init(XDebugProcess process, @NotNull XDebugSessionData sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "init"));
        }
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebugProcess = process;
        this.mySessionData = sessionData;
        if (this.autoInitBreakpoints && this.myDebugProcess.checkCanInitBreakpoints()) {
            this.initBreakpoints();
        }
        this.myDebugProcess.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                XDebugSessionImpl.this.stopImpl();
            }
        });
        this.myConsoleView = (ConsoleView)this.myDebugProcess.createConsole();
        if (!this.myShowTabOnSuspend) {
            this.initSessionTab();
        }
        return this.mySessionTab;
    }

    public void initBreakpoints() {
        LOG.assertTrue(!this.breakpointsInitialized);
        this.breakpointsInitialized = true;
        XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
        XDependentBreakpointManager dependentBreakpointManager = breakpointManager.getDependentBreakpointManager();
        this.disableSlaveBreakpoints(dependentBreakpointManager);
        this.processAllBreakpoints(true, false);
        this.myBreakpointListener = new MyBreakpointListener();
        breakpointManager.addBreakpointListener(this.myBreakpointListener);
        this.myDependentBreakpointListener = new MyDependentBreakpointListener();
        dependentBreakpointManager.addListener(this.myDependentBreakpointListener);
    }

    public ConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    public XDebugSessionTab getSessionTab() {
        return this.mySessionTab;
    }

    public RunnerLayoutUi getUI() {
        return this.mySessionTab.getUi();
    }

    private void initSessionTab() {
        this.mySessionTab = new XDebugSessionTab(this.myProject, this, this.myIcon, this.myEnvironment, this.myRunner);
        this.myDebugProcess.sessionInitialized();
    }

    public XDebugSessionData getSessionData() {
        return this.mySessionData;
    }

    private void disableSlaveBreakpoints(XDependentBreakpointManager dependentBreakpointManager) {
        Set<XBreakpoint<?>> slaveBreakpoints = dependentBreakpointManager.getAllSlaveBreakpoints();
        if (slaveBreakpoints.isEmpty()) {
            return;
        }
        THashSet breakpointTypes = new THashSet();
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            breakpointTypes.add(XDebugSessionImpl.getBreakpointTypeClass(handler));
        }
        for (XBreakpoint<?> slaveBreakpoint : slaveBreakpoints) {
            if (!breakpointTypes.contains(slaveBreakpoint.getType())) continue;
            this.myInactiveSlaveBreakpoints.add(slaveBreakpoint);
        }
    }

    public void showSessionTab() {
        RunContentDescriptor descriptor = this.getRunContentDescriptor();
        ExecutionManager.getInstance((Project)this.getProject()).getContentManager().showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
    }

    public XValueMarkers<?, ?> getValueMarkers() {
        XValueMarkerProvider provider;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myValueMarkers == null && (provider = this.myDebugProcess.createValueMarkerProvider()) != null) {
            this.myValueMarkers = XValueMarkers.createValueMarkers(provider);
        }
        return this.myValueMarkers;
    }

    private static XBreakpointType getBreakpointTypeClass(XBreakpointHandler handler) {
        return XDebuggerUtil.getInstance().findBreakpointType(handler.getBreakpointTypeClass());
    }

    private <B extends XBreakpoint<?>> void processBreakpoints(XBreakpointHandler<B> handler, boolean register, boolean temporary) {
        Collection breakpoints = this.myDebuggerManager.getBreakpointManager().getBreakpoints(handler.getBreakpointTypeClass());
        for (XBreakpoint b : breakpoints) {
            this.handleBreakpoint(handler, b, register, temporary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <B extends XBreakpoint<?>> void handleBreakpoint(XBreakpointHandler<B> handler, B b, boolean register, boolean temporary) {
        if (register && this.isBreakpointActive(b)) {
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
            synchronized (map) {
                this.myRegisteredBreakpoints.put(b, new CustomizedBreakpointPresentation());
            }
            handler.registerBreakpoint(b);
        }
        if (!register) {
            boolean removed;
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
            synchronized (map) {
                removed = this.myRegisteredBreakpoints.remove(b) != null;
            }
            if (removed) {
                handler.unregisterBreakpoint(b, temporary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CustomizedBreakpointPresentation getBreakpointPresentation(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "getBreakpointPresentation"));
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            return this.myRegisteredBreakpoints.get(breakpoint);
        }
    }

    private void processAllHandlers(XBreakpoint<?> breakpoint, boolean register) {
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoint(breakpoint, handler, register);
        }
    }

    private <B extends XBreakpoint<?>> void processBreakpoint(XBreakpoint<?> breakpoint, XBreakpointHandler<B> handler, boolean register) {
        XBreakpointType type = breakpoint.getType();
        if (handler.getBreakpointTypeClass().equals(type.getClass())) {
            XBreakpoint<?> b = breakpoint;
            this.handleBreakpoint(handler, b, register, false);
        }
    }

    private boolean isBreakpointActive(XBreakpoint<?> b) {
        return !this.myBreakpointsMuted && b.isEnabled() && !this.myInactiveSlaveBreakpoints.contains(b);
    }

    public boolean areBreakpointsMuted() {
        return this.myBreakpointsMuted;
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "addSessionListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "addSessionListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "addSessionListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeSessionListener(@NotNull XDebugSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "removeSessionListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setBreakpointMuted(boolean muted) {
        if (this.myBreakpointsMuted == muted) {
            return;
        }
        this.myBreakpointsMuted = muted;
        this.processAllBreakpoints(!muted, muted);
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    public void stepOver(boolean ignoreBreakpoints) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.doResume();
        this.myDebugProcess.startStepOver();
    }

    public void stepInto() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.doResume();
        this.myDebugProcess.startStepInto();
    }

    public void stepOut() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.doResume();
        this.myDebugProcess.startStepOut();
    }

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> handler, V variant) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.doResume();
        handler.startStepInto(variant);
    }

    public void forceStepInto() {
        this.stepInto();
    }

    public void runToPosition(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "runToPosition"));
        }
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.doResume();
        this.myDebugProcess.runToPosition(position);
    }

    public void pause() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startPausing();
    }

    private void processAllBreakpoints(boolean register, boolean temporary) {
        for (XBreakpointHandler handler : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoints(handler, register, temporary);
        }
    }

    private void disableBreakpoints() {
        this.myBreakpointsDisabled = true;
        this.processAllBreakpoints(false, true);
    }

    public void resume() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.doResume();
        this.myDebugProcess.resume();
    }

    private void doResume() {
        if (!this.myPaused.getAndSet(false)) {
            return;
        }
        final XSourcePosition oldPosition = this.myCurrentPosition;
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).beforeSessionResume();
        this.myDebuggerManager.setActiveSession(this, null, false, null);
        this.mySuspendContext = null;
        this.myCurrentExecutionStack = null;
        this.myCurrentStackFrame = null;
        this.myCurrentPosition = null;
        this.myActiveNonLineBreakpoint = null;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (XDebugSessionImpl.this.mySessionTab != null) {
                    XDebugSessionImpl.this.mySessionTab.getUi().clearAttractionBy("breakpoint");
                }
                if (oldPosition != null) {
                    XDebugSessionImpl.this.adjustMouseTrackingCounter(oldPosition, -1);
                }
            }
        });
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionResumed();
    }

    public void updateExecutionPosition() {
        boolean isTopFrame = this.isTopFrameSelected();
        this.myDebuggerManager.updateExecutionPoint(this.myCurrentStackFrame.getSourcePosition(), !isTopFrame, this.getPositionIconRenderer(isTopFrame));
    }

    private boolean isTopFrameSelected() {
        return this.myCurrentExecutionStack != null && this.myCurrentExecutionStack.getTopFrame() == this.myCurrentStackFrame;
    }

    public void showExecutionPoint() {
        XStackFrame topFrame;
        XExecutionStack executionStack;
        if (this.mySuspendContext != null && (executionStack = this.mySuspendContext.getActiveExecutionStack()) != null && (topFrame = executionStack.getTopFrame()) != null) {
            this.setCurrentStackFrame(executionStack, topFrame);
            this.myDebuggerManager.showExecutionPosition();
        }
    }

    public void setCurrentStackFrame(@NotNull XStackFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "setCurrentStackFrame"));
        }
        this.setCurrentStackFrame(this.myCurrentExecutionStack, frame);
    }

    public void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame) {
        if (executionStack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "setCurrentStackFrame"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "setCurrentStackFrame"));
        }
        if (this.mySuspendContext == null) {
            return;
        }
        boolean frameChanged = this.myCurrentStackFrame != frame;
        this.myCurrentExecutionStack = executionStack;
        this.myCurrentStackFrame = frame;
        this.activateSession();
        if (frameChanged) {
            ((XDebugSessionListener)this.myDispatcher.getMulticaster()).stackFrameChanged();
        }
    }

    public void activateSession() {
        XSourcePosition position;
        XSourcePosition xSourcePosition = position = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        if (position != null) {
            boolean isTopFrame = this.isTopFrameSelected();
            this.myDebuggerManager.setActiveSession(this, position, !isTopFrame, this.getPositionIconRenderer(isTopFrame));
        } else {
            this.myDebuggerManager.setActiveSession(this, null, false, null);
        }
    }

    public XBreakpoint<?> getActiveNonLineBreakpoint() {
        return this.myActiveNonLineBreakpoint;
    }

    @Nullable
    private GutterIconRenderer getPositionIconRenderer(boolean isTopFrame) {
        if (!isTopFrame) {
            return null;
        }
        if (this.myActiveNonLineBreakpoint != null) {
            return ((XBreakpointBase)this.myActiveNonLineBreakpoint).createGutterIconRenderer();
        }
        if (this.myCurrentExecutionStack != null) {
            return this.myCurrentExecutionStack.getExecutionLineIconRenderer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "updateBreakpointPresentation"));
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map = this.myRegisteredBreakpoints;
        synchronized (map) {
            CustomizedBreakpointPresentation presentation = this.myRegisteredBreakpoints.get(breakpoint);
            if (presentation == null || Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
                return;
            }
            presentation.setErrorMessage(errorMessage);
            presentation.setIcon(icon);
        }
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate((XLineBreakpointImpl)breakpoint);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "breakpointReached"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "breakpointReached"));
        }
        return this.breakpointReached(breakpoint, null, suspendContext);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "breakpointReached"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/XDebugSessionImpl", "breakpointReached"));
        }
        XDebuggerEvaluator evaluator = XDebuggerUtilImpl.getEvaluator(suspendContext);
        String condition = breakpoint.getCondition();
        if (condition != null && evaluator != null) {
            LOG.debug("evaluating condition: " + condition);
            boolean result = evaluator.evaluateCondition(condition);
            LOG.debug("condition evaluates to " + result);
            if (!result) {
                return false;
            }
        }
        if (breakpoint.isLogMessage()) {
            String text = StringUtil.decapitalize((String)XBreakpointUtil.getDisplayText(breakpoint));
            XSourcePosition position = breakpoint.getSourcePosition();
            OpenFileHyperlinkInfo hyperlinkInfo = position != null ? new OpenFileHyperlinkInfo(this.myProject, position.getFile(), position.getLine()) : null;
            this.printMessage(XDebuggerBundle.message((String)"xbreakpoint.reached.text", (Object[])new Object[0]) + " ", text, (HyperlinkInfo)hyperlinkInfo);
        }
        if (evaluatedLogExpression != null) {
            this.printMessage(evaluatedLogExpression, null, null);
        } else {
            String expression = breakpoint.getLogExpression();
            if (expression != null && evaluator != null) {
                LOG.debug("evaluating log expression: " + expression);
                String message = evaluator.evaluateMessage(expression);
                if (message != null) {
                    this.printMessage(message, null, null);
                }
            }
        }
        this.processDependencies(breakpoint);
        if (breakpoint.getSuspendPolicy() == SuspendPolicy.NONE) {
            return false;
        }
        this.myActiveNonLineBreakpoint = !(breakpoint instanceof XLineBreakpoint) ? breakpoint : null;
        this.positionReached(suspendContext);
        if (breakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)breakpoint).isTemporary()) {
            this.handleTemporaryBreakpointHit(breakpoint);
        }
        return true;
    }

    private void handleTemporaryBreakpointHit(final XBreakpoint<?> breakpoint) {
        this.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            private void removeBreakpoint() {
                XDebuggerUtil.getInstance().removeBreakpoint(XDebugSessionImpl.this.myProject, breakpoint);
                XDebugSessionImpl.this.removeSessionListener((XDebugSessionListener)this);
            }

            public void sessionResumed() {
                this.removeBreakpoint();
            }

            public void sessionStopped() {
                this.removeBreakpoint();
            }
        });
    }

    private void processDependencies(XBreakpoint<?> breakpoint) {
        boolean added;
        XDependentBreakpointManager dependentBreakpointManager = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager();
        if (!dependentBreakpointManager.isMasterOrSlave(breakpoint)) {
            return;
        }
        List<XBreakpoint<?>> breakpoints = dependentBreakpointManager.getSlaveBreakpoints(breakpoint);
        this.myInactiveSlaveBreakpoints.removeAll(breakpoints);
        for (XBreakpoint<?> slaveBreakpoint : breakpoints) {
            this.processAllHandlers(slaveBreakpoint, true);
        }
        if (dependentBreakpointManager.getMasterBreakpoint(breakpoint) != null && !dependentBreakpointManager.isLeaveEnabled(breakpoint) && (added = this.myInactiveSlaveBreakpoints.add(breakpoint))) {
            this.processAllHandlers(breakpoint, false);
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate(breakpoint);
        }
    }

    private void printMessage(final String message, final String hyperLinkText, final @Nullable HyperlinkInfo info) {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                XDebugSessionImpl.this.myConsoleView.print(message, ConsoleViewContentType.SYSTEM_OUTPUT);
                if (info != null) {
                    XDebugSessionImpl.this.myConsoleView.printHyperlink(hyperLinkText, info);
                } else if (hyperLinkText != null) {
                    XDebugSessionImpl.this.myConsoleView.print(hyperLinkText, ConsoleViewContentType.SYSTEM_OUTPUT);
                }
                XDebugSessionImpl.this.myConsoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    public void positionReached(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "positionReached"));
        }
        this.enableBreakpoints();
        this.mySuspendContext = suspendContext;
        this.myCurrentExecutionStack = suspendContext.getActiveExecutionStack();
        this.myCurrentStackFrame = this.myCurrentExecutionStack != null ? this.myCurrentExecutionStack.getTopFrame() : null;
        this.myCurrentPosition = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        this.myPaused.set(true);
        if (this.myCurrentPosition != null) {
            this.myDebuggerManager.setActiveSession(this, this.myCurrentPosition, false, this.getPositionIconRenderer(true));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (XDebugSessionImpl.this.myShowTabOnSuspend) {
                    XDebugSessionImpl.this.myShowTabOnSuspend = false;
                    XDebugSessionImpl.this.initSessionTab();
                    XDebugSessionImpl.this.showSessionTab();
                }
                XDebugSessionImpl.this.mySessionTab.toFront();
                XDebugSessionImpl.this.mySessionTab.getUi().attractBy("breakpoint");
                if (XDebugSessionImpl.this.myCurrentPosition != null) {
                    XDebugSessionImpl.this.adjustMouseTrackingCounter(XDebugSessionImpl.this.myCurrentPosition, 1);
                }
            }
        });
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionPaused();
    }

    private void adjustMouseTrackingCounter(@NotNull XSourcePosition position, int increment) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "adjustMouseTrackingCounter"));
        }
        Editor editor = XDebuggerUtilImpl.createEditor(XSourcePositionImpl.createOpenFileDescriptor(this.myProject, position));
        if (editor != null) {
            JComponent component = editor.getComponent();
            Object o = component.getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING);
            Integer value = (o instanceof Integer ? (Integer)o : 0) + increment;
            component.putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, value > 0 ? value : null);
        }
    }

    public void sessionResumed() {
        this.doResume();
    }

    private void enableBreakpoints() {
        if (this.myBreakpointsDisabled) {
            this.myBreakpointsDisabled = false;
            new ReadAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl$6", "run"));
                    }
                    XDebugSessionImpl.this.processAllBreakpoints(true, false);
                }
            }.execute();
        }
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    private void stopImpl() {
        if (this.myStopped) {
            return;
        }
        this.myDebugProcess.stop();
        this.myCurrentPosition = null;
        this.myCurrentExecutionStack = null;
        this.myCurrentStackFrame = null;
        this.mySuspendContext = null;
        this.myDebuggerManager.setActiveSession(this, null, false, null);
        if (this.breakpointsInitialized) {
            XBreakpointManagerImpl breakpointManager = this.myDebuggerManager.getBreakpointManager();
            breakpointManager.removeBreakpointListener(this.myBreakpointListener);
            breakpointManager.getDependentBreakpointManager().removeListener(this.myDependentBreakpointListener);
        }
        this.myStopped = true;
        this.myDebuggerManager.removeSession(this);
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionStopped();
    }

    public boolean isInactiveSlaveBreakpoint(XBreakpoint<?> breakpoint) {
        return this.myInactiveSlaveBreakpoints.contains(breakpoint);
    }

    public void stop() {
        ProcessHandler processHandler = this.myDebugProcess.getProcessHandler();
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            return;
        }
        if (processHandler.detachIsDefault()) {
            processHandler.detachProcess();
        } else {
            processHandler.destroyProcess();
        }
    }

    public void reportError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "reportError"));
        }
        this.reportMessage(message, MessageType.ERROR);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "reportMessage"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "reportMessage"));
        }
        this.reportMessage(message, type, null);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type, final @Nullable HyperlinkListener listener) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl", "reportMessage"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl", "reportMessage"));
        }
        NotificationListener notificationListener = listener == null ? null : new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl$7", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/XDebugSessionImpl$7", "hyperlinkUpdate"));
                }
                listener.hyperlinkUpdate(event);
            }
        };
        NOTIFICATION_GROUP.createNotification("", message, type.toNotificationType(), notificationListener).notify(this.myProject);
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(XBreakpoint<?> slave, XBreakpoint<?> master) {
            boolean added = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.add(slave);
            if (added) {
                XDebugSessionImpl.this.processAllHandlers(slave, false);
            }
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            boolean removed = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.remove(breakpoint);
            if (removed) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }
    }

    private class MyBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        private MyBreakpointListener() {
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener", "breakpointAdded"));
            }
            if (!XDebugSessionImpl.this.myBreakpointsDisabled) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener", "breakpointRemoved"));
            }
            XDebugSessionImpl.this.processAllHandlers(breakpoint, false);
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener", "breakpointChanged"));
            }
            this.breakpointRemoved(breakpoint);
            this.breakpointAdded(breakpoint);
        }
    }
}

