/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.graph.PaintInfo;
import com.intellij.vcs.log.graph.render.GraphCommitCell;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.RefPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPaddingCellRender
extends ColoredTableCellRenderer {
    private static final Logger LOG = Logger.getInstance(AbstractPaddingCellRender.class);
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefPainter myRefPainter;
    @NotNull
    private final IssueLinkRenderer myIssueLinkRenderer;
    @Nullable
    private PaintInfo myGraphImage;
    @Nullable
    private Collection<VcsRef> myRefs;

    protected AbstractPaddingCellRender(@NotNull VcsLogColorManager colorManager, @NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogGraphTable table) {
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "<init>"));
        }
        this.myDataHolder = dataHolder;
        this.myGraphTable = table;
        this.myRefPainter = new RefPainter(colorManager, false);
        this.myIssueLinkRenderer = new IssueLinkRenderer(dataHolder.getProject(), (SimpleColoredComponent)this);
    }

    @Nullable
    protected abstract PaintInfo getGraphImage(int var1);

    protected void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int graphPadding;
        if (value == null) {
            return;
        }
        GraphCommitCell cell = AbstractPaddingCellRender.getAssertCommitCell(value);
        this.myGraphImage = this.getGraphImage(row);
        this.myRefs = cell.getRefsToThisCommit();
        if (this.myGraphImage != null) {
            graphPadding = this.myGraphImage.getWidth();
            if (graphPadding < 2) {
                LOG.error("Too small image width: " + graphPadding);
            }
        } else {
            graphPadding = 0;
        }
        int textPadding = graphPadding + this.calcRefsPadding(this.myRefs);
        this.setBorder(null);
        this.append("");
        this.appendFixedTextFragmentWidth(textPadding);
        this.myGraphTable.applyHighlighters((Component)((Object)this), row, isSelected);
        this.myIssueLinkRenderer.appendTextWithLinks(cell.getText());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myRefs != null) {
            int graphPadding = this.myGraphImage != null ? this.myGraphImage.getWidth() : 0;
            this.drawRefs((Graphics2D)g, this.myRefs, graphPadding);
        }
        if (this.myGraphImage != null) {
            UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
        } else {
            LOG.error("Image is null");
        }
    }

    private static GraphCommitCell getAssertCommitCell(Object value) {
        assert (value instanceof GraphCommitCell) : "Value of incorrect class was supplied: " + value;
        return (GraphCommitCell)value;
    }

    protected void drawRefs(@NotNull Graphics2D g2, @NotNull Collection<VcsRef> refs, int padding) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "drawRefs"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "drawRefs"));
        }
        this.myRefPainter.drawLabels(g2, this.collectLabelsForRefs(refs), padding);
    }

    @NotNull
    private Map<String, Color> collectLabelsForRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "collectLabelsForRefs"));
        }
        if (refs.isEmpty()) {
            Map<String, Color> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "collectLabelsForRefs"));
            }
            return map;
        }
        VirtualFile root = refs.iterator().next().getRoot();
        refs = this.myDataHolder.getLogProvider(root).getReferenceManager().sort(refs);
        List<VcsRef> branches = AbstractPaddingCellRender.getBranches(refs);
        Collection tags = ContainerUtil.subtract((Collection)refs, branches);
        Map<String, Color> map = AbstractPaddingCellRender.getLabelsForRefs(branches, tags);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "collectLabelsForRefs"));
        }
        return map;
    }

    protected int calcRefsPadding(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "calcRefsPadding"));
        }
        return this.myRefPainter.padding(this.collectLabelsForRefs(refs).keySet(), this.getFontMetrics(RefPainter.DEFAULT_FONT));
    }

    @NotNull
    private static Map<String, Color> getLabelsForRefs(@NotNull List<VcsRef> branches, @NotNull Collection<VcsRef> tags) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "getLabelsForRefs"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "getLabelsForRefs"));
        }
        LinkedHashMap labels = ContainerUtil.newLinkedHashMap();
        for (VcsRef branch : branches) {
            labels.put(branch.getName(), branch.getType().getBackgroundColor());
        }
        if (!tags.isEmpty()) {
            VcsRef firstTag = tags.iterator().next();
            Color color = firstTag.getType().getBackgroundColor();
            if (tags.size() > 1) {
                labels.put(firstTag.getName() + " +", color);
            } else {
                labels.put(firstTag.getName(), color);
            }
        }
        LinkedHashMap linkedHashMap = labels;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/AbstractPaddingCellRender", "getLabelsForRefs"));
        }
        return linkedHashMap;
    }

    private static List<VcsRef> getBranches(Collection<VcsRef> refs) {
        return ContainerUtil.filter(refs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
    }
}

