/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final DefaultActionGroup myActionGroup;
    @NotNull
    private final BranchFilterPopupComponent myBranchFilterComponent;
    @NotNull
    private final UserFilterPopupComponent myUserFilterComponent;
    @NotNull
    private final DateFilterPopupComponent myDateFilterComponent;
    @NotNull
    private final StructureFilterPopupComponent myStructureFilterComponent;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull DataPack initialDataPack) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        this.myUi = ui;
        this.myTextFilter = new SearchTextFieldWithStoredHistory("Vcs.Log.Text.Filter.History"){

            protected void onFieldCleared() {
                VcsLogClassicFilterUi.this.applyFilters();
            }
        };
        this.myTextFilter.getTextEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsLogClassicFilterUi.this.applyFilters();
                VcsLogClassicFilterUi.this.myTextFilter.addCurrentTextToHistory();
            }
        });
        this.myBranchFilterComponent = new BranchFilterPopupComponent(this, initialDataPack, uiProperties);
        this.myUserFilterComponent = new UserFilterPopupComponent(this, logDataHolder, uiProperties);
        this.myDateFilterComponent = new DateFilterPopupComponent(this);
        this.myStructureFilterComponent = new StructureFilterPopupComponent(this, logDataHolder.getRoots());
        this.myActionGroup = new DefaultActionGroup();
        this.myActionGroup.add((AnAction)new TextFilterComponent(this.myTextFilter));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myBranchFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myUserFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myDateFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myStructureFilterComponent));
    }

    public void updateDataPack(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "updateDataPack"));
        }
        this.myBranchFilterComponent.updateDataPack(dataPack);
    }

    @NotNull
    public ActionGroup getFilterActionComponents() {
        DefaultActionGroup defaultActionGroup = this.myActionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFilterActionComponents"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogTextFilterImpl textFilter = !this.myTextFilter.getText().isEmpty() ? new VcsLogTextFilterImpl(this.myTextFilter.getText().trim()) : null;
        VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(this.myBranchFilterComponent.getFilter(), this.myUserFilterComponent.getFilter(), this.myDateFilterComponent.getFilter(), textFilter, this.myStructureFilterComponent.getFilter());
        if (vcsLogFilterCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFilters"));
        }
        return vcsLogFilterCollectionImpl;
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "setFilter"));
        }
        if (filter instanceof VcsLogBranchFilter) {
            Collection values = ((VcsLogBranchFilter)filter).getBranchNames();
            this.myBranchFilterComponent.apply(values, MultipleValueFilterPopupComponent.displayableText(values), MultipleValueFilterPopupComponent.tooltip(values));
        }
    }

    void applyFilters() {
        this.myUi.applyFiltersAndUpdateUi();
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        private final FilterPopupComponent myComponent;

        public FilterActionComponent(FilterPopupComponent component) {
            this.myComponent = component;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return this.myComponent;
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }

    private static class TextFilterComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        private final SearchTextField mySearchField;

        TextFilterComponent(SearchTextField searchField) {
            this.mySearchField = searchField;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JPanel panel = new JPanel();
            JLabel filterCaption = new JLabel("Filter:");
            filterCaption.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
            panel.add(filterCaption);
            panel.add((Component)this.mySearchField);
            return panel;
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

