/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogFilterChangeListener;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogRefreshListener;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.graph.ChangeCursorActionRequest;
import com.intellij.vcs.log.graph.ClickGraphAction;
import com.intellij.vcs.log.graph.GraphAction;
import com.intellij.vcs.log.graph.GraphActionRequest;
import com.intellij.vcs.log.graph.GraphAnswer;
import com.intellij.vcs.log.graph.GraphChange;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.graph.JumpToRowActionRequest;
import com.intellij.vcs.log.graph.LinearBranchesExpansionAction;
import com.intellij.vcs.log.graph.LongEdgesAction;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.tables.AbstractVcsLogTableModel;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.awt.Component;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
implements VcsLogUi,
Disposable {
    public static final String POPUP_ACTION_GROUP = "Vcs.Log.ContextMenu";
    public static final String TOOLBAR_ACTION_GROUP = "Vcs.Log.Toolbar";
    public static final String VCS_LOG_TABLE_PLACE = "Vcs.Log.ContextMenu";
    private static final Logger LOG = Logger.getInstance(VcsLogUiImpl.class);
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final VcsLogFilterer myFilterer;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final Collection<VcsLogFilterChangeListener> myFilterChangeListeners;
    @NotNull
    private DataPack myDataPack;

    public VcsLogUiImpl(@NotNull VcsLogDataHolder logDataHolder, @NotNull Project project, @NotNull VcsLogSettings settings, @NotNull VcsLogColorManager manager, @NotNull VcsLogUiProperties uiProperties, @NotNull DataPack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        this.myFilterChangeListeners = ContainerUtil.newArrayList();
        this.myLogDataHolder = logDataHolder;
        this.myProject = project;
        this.myColorManager = manager;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        Disposer.register((Disposable)logDataHolder, (Disposable)this);
        this.myFilterer = new VcsLogFilterer(logDataHolder, this);
        this.myLog = new VcsLogImpl(this.myLogDataHolder, this);
        this.myMainFrame = new MainFrame(this.myLogDataHolder, this, project, settings, uiProperties, this.myLog, initialDataPack);
        project.getMessageBus().connect((Disposable)project).subscribe(VcsLogDataHolder.REFRESH_COMPLETED, (Object)new VcsLogRefreshListener(){

            @Override
            public void refresh(@NotNull DataPack dataPack) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl$1", "refresh"));
                }
                VcsLogUiImpl.this.applyFiltersAndUpdateUi(dataPack);
            }
        });
        this.applyFiltersAndUpdateUi(initialDataPack);
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getMainFrame"));
        }
        return mainFrame;
    }

    public void jumpToRow(final int rowIndex) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().jumpToRow(rowIndex);
            }
        });
    }

    public void setModel(@NotNull AbstractVcsLogTableModel newModel, @NotNull DataPack newDataPack, @NotNull TIntHashSet previouslySelectedCommits) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        if (newDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        if (previouslySelectedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        VcsLogGraphTable table = this.getTable();
        table.setModel(newModel);
        VcsLogUiImpl.restoreSelection(newModel, newDataPack, previouslySelectedCommits, table);
        table.setPaintBusy(false);
    }

    private static void restoreSelection(@NotNull AbstractVcsLogTableModel newModel, @NotNull DataPack newDataPack, @NotNull TIntHashSet previouslySelectedCommits, final @NotNull VcsLogGraphTable table) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (newDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (previouslySelectedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        TIntHashSet rowsToSelect = VcsLogUiImpl.findNewRowsToSelect(newModel, newDataPack, previouslySelectedCommits);
        rowsToSelect.forEach(new TIntProcedure(){

            public boolean execute(int row) {
                table.addRowSelectionInterval(row, row);
                return true;
            }
        });
    }

    @NotNull
    private static TIntHashSet findNewRowsToSelect(@NotNull AbstractVcsLogTableModel newModel, @NotNull DataPack dataPack, @NotNull TIntHashSet selectedHashes) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        if (selectedHashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        TIntHashSet rowsToSelect = new TIntHashSet();
        if (newModel.getRowCount() == 0) {
            TIntHashSet tIntHashSet = rowsToSelect;
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
            }
            return tIntHashSet;
        }
        GraphFacade facade = dataPack.getGraphFacade();
        for (int row = 0; row < facade.getVisibleCommitCount() && rowsToSelect.size() < selectedHashes.size(); ++row) {
            int commit = facade.getCommitAtRow(row);
            if (!selectedHashes.contains(commit)) continue;
            rowsToSelect.add(row);
        }
        TIntHashSet tIntHashSet = rowsToSelect;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        return tIntHashSet;
    }

    public void repaintUI() {
        this.myMainFrame.getGraphTable().repaint();
    }

    public void showAll() {
        this.runUnderModalProgress("Expanding linear branches...", new Runnable(){

            @Override
            public void run() {
                final GraphAnswer answer = VcsLogUiImpl.this.myDataPack.getGraphFacade().performAction((GraphAction)LinearBranchesExpansionAction.EXPAND);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsLogUiImpl.this.handleAnswer(answer);
                        VcsLogUiImpl.this.jumpToRow(0);
                    }
                });
            }
        });
    }

    public void hideAll() {
        this.runUnderModalProgress("Collapsing linear branches...", new Runnable(){

            @Override
            public void run() {
                final GraphAnswer answer = VcsLogUiImpl.this.myDataPack.getGraphFacade().performAction((GraphAction)LinearBranchesExpansionAction.COLLAPSE);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsLogUiImpl.this.handleAnswer(answer);
                        VcsLogUiImpl.this.jumpToRow(0);
                    }
                });
            }
        });
    }

    public void setLongEdgeVisibility(boolean visibility) {
        this.handleAnswer(this.myDataPack.getGraphFacade().performAction((GraphAction)LongEdgesAction.valueOf((boolean)visibility)));
        this.myUiProperties.setLongEdgesVisibility(visibility);
    }

    public boolean areLongEdgesHidden() {
        return this.myDataPack.getGraphFacade().getInfoProvider().areLongEdgesHidden();
    }

    public void click(int rowIndex) {
        this.handleAnswer(this.myDataPack.getGraphFacade().performAction((GraphAction)new ClickGraphAction(rowIndex, null)));
    }

    public void jumpToCommit(@NotNull Hash commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommit"));
        }
        this.jumpTo(commitHash, new PairFunction<AbstractVcsLogTableModel, Hash, Integer>(){

            public Integer fun(AbstractVcsLogTableModel model, Hash hash) {
                return model.getRowOfCommit(hash);
            }
        });
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommitByPartOfHash"));
        }
        this.jumpTo(commitHash, new PairFunction<AbstractVcsLogTableModel, String, Integer>(){

            public Integer fun(AbstractVcsLogTableModel model, String hash) {
                return model.getRowOfCommitByPartOfHash(hash);
            }
        });
    }

    public void handleAnswer(@Nullable GraphAnswer answer) {
        GraphActionRequest actionRequest;
        this.repaintUI();
        if (answer == null) {
            return;
        }
        GraphChange graphChange = answer.getGraphChange();
        if (graphChange != null) {
            ((AbstractTableModel)this.getTable().getModel()).fireTableStructureChanged();
        }
        if ((actionRequest = answer.getActionRequest()) instanceof JumpToRowActionRequest) {
            int row = ((JumpToRowActionRequest)actionRequest).getRow();
            this.jumpToRow(row);
        } else if (actionRequest instanceof ChangeCursorActionRequest) {
            this.myMainFrame.setCursor(((ChangeCursorActionRequest)actionRequest).getCursor());
        }
    }

    private <T> void jumpTo(final @NotNull T commitId, final @NotNull PairFunction<AbstractVcsLogTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        if (rowGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        AbstractVcsLogTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        int row = (Integer)rowGetter.fun((Object)model, commitId);
        if (row >= 0) {
            this.jumpToRow(row);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(new Runnable(){

                @Override
                public void run() {
                    VcsLogUiImpl.this.jumpTo(commitId, rowGetter);
                }
            });
        } else {
            this.commitNotFound(commitId.toString());
        }
    }

    @Nullable
    private AbstractVcsLogTableModel getModel() {
        TableModel model = this.getTable().getModel();
        if (model instanceof AbstractVcsLogTableModel) {
            return (AbstractVcsLogTableModel)model;
        }
        this.showMessage(MessageType.WARNING, "The log is not ready to search yet");
        return null;
    }

    private void showMessage(@NotNull MessageType messageType, @NotNull String message) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        LOG.info(message);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, messageType, new NamedRunnable[0]);
    }

    private void commitNotFound(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "commitNotFound"));
        }
        if (this.getFilters().isEmpty()) {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " not found");
        } else {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " doesn't exist or doesn't match the active filters");
        }
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getColorManager"));
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLogFilterer getFilterer() {
        VcsLogFilterer vcsLogFilterer = this.myFilterer;
        if (vcsLogFilterer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterer"));
        }
        return vcsLogFilterer;
    }

    @NotNull
    public TIntHashSet getSelectedCommits() {
        int[] selectedRows = this.getTable().getSelectedRows();
        TIntHashSet tIntHashSet = VcsLogUiImpl.getCommitsAtRows(this.myDataPack.getGraphFacade(), selectedRows);
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getSelectedCommits"));
        }
        return tIntHashSet;
    }

    @NotNull
    private static TIntHashSet getCommitsAtRows(@NotNull GraphFacade facade, int[] rows) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getCommitsAtRows"));
        }
        TIntHashSet commits = new TIntHashSet();
        for (int row : rows) {
            int commit = facade.getCommitAtRow(row);
            if (commit <= 0) continue;
            commits.add(commit);
        }
        TIntHashSet tIntHashSet = commits;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getCommitsAtRows"));
        }
        return tIntHashSet;
    }

    private void applyFiltersAndUpdateUi(final @NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "applyFiltersAndUpdateUi"));
        }
        this.runUnderModalProgress("Applying filters...", new Runnable(){

            @Override
            public void run() {
                final TIntHashSet previouslySelected = VcsLogUiImpl.this.getSelectedCommits();
                final AbstractVcsLogTableModel newModel = VcsLogUiImpl.this.myFilterer.applyFiltersAndUpdateUi(dataPack, VcsLogUiImpl.this.getFilters());
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsLogUiImpl.this.myDataPack = dataPack;
                        VcsLogUiImpl.this.setModel(newModel, VcsLogUiImpl.this.myDataPack, previouslySelected);
                        VcsLogUiImpl.this.myMainFrame.updateDataPack(VcsLogUiImpl.this.myDataPack);
                        VcsLogUiImpl.this.setLongEdgeVisibility(VcsLogUiImpl.this.myUiProperties.areLongEdgesVisible());
                        VcsLogUiImpl.this.fireFilterChangeEvent();
                        VcsLogUiImpl.this.repaintUI();
                        if (newModel.getRowCount() == 0) {
                            newModel.requestToLoadMore(EmptyRunnable.INSTANCE);
                        }
                    }
                });
            }
        });
    }

    public void applyFiltersAndUpdateUi() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.applyFiltersAndUpdateUi(this.myDataPack);
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myMainFrame.getFilterUi().getFilters();
        if (vcsLogFilterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilters"));
        }
        return vcsLogFilterCollection;
    }

    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getProject"));
        }
        return project;
    }

    public void runUnderModalProgress(final @NotNull String task, final @NotNull Runnable runnable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "runUnderModalProgress"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/ui/VcsLogUiImpl", "runUnderModalProgress"));
        }
        this.getTable().executeWithoutRepaint(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, task, false, null, VcsLogUiImpl.this.getMainFrame().getMainComponent());
            }
        });
        this.repaintUI();
    }

    public void setBranchesPanelVisible(boolean visible) {
        this.myMainFrame.setBranchesPanelVisible(visible);
    }

    public Component getToolbar() {
        return this.myMainFrame.getToolbar();
    }

    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getVcsLog"));
        }
        return vcsLog;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogFilterUi vcsLogFilterUi = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterUi"));
        }
        return vcsLogFilterUi;
    }

    @NotNull
    public DataPack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DataPack dataPack = this.myDataPack;
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getDataPack"));
        }
        return dataPack;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "addHighlighter"));
        }
        this.getTable().addHighlighter(highlighter);
        this.repaintUI();
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "removeHighlighter"));
        }
        this.getTable().removeHighlighter(highlighter);
        this.repaintUI();
    }

    public void addFilterChangeListener(@NotNull VcsLogFilterChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "addFilterChangeListener"));
        }
        this.myFilterChangeListeners.add(listener);
    }

    public void removeFilterChangeListener(@NotNull VcsLogFilterChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogUiImpl", "removeFilterChangeListener"));
        }
        this.myFilterChangeListeners.remove(listener);
    }

    private void fireFilterChangeEvent() {
        for (VcsLogFilterChangeListener listener : this.myFilterChangeListeners) {
            listener.filtersPossiblyChanged();
        }
    }

    public void dispose() {
        this.getTable().removeAllHighlighters();
    }
}

