/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogQuickSettingsActions
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        VcsLogSettings settings = (VcsLogSettings)ServiceManager.getService((Project)project, VcsLogSettings.class);
        VcsLogManager logManager = (VcsLogManager)ServiceManager.getService((Project)project, VcsLogManager.class);
        VcsLogUiImpl logUi = logManager.getLogUi();
        if (logUi == null) {
            return;
        }
        MySettingsActionGroup settingsGroup = new MySettingsActionGroup(settings, logUi);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)settingsGroup);
        int x = 0;
        int y = 0;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            x = ((MouseEvent)inputEvent).getX();
            y = ((MouseEvent)inputEvent).getY();
        }
        popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            VcsLogManager logManager = (VcsLogManager)ServiceManager.getService((Project)project, VcsLogManager.class);
            e.getPresentation().setEnabledAndVisible(logManager.getLogUi() != null);
        }
    }

    private static class MySettingsActionGroup
    extends ActionGroup {
        private final VcsLogSettings mySettings;
        private final VcsLogUiImpl myUi;

        public MySettingsActionGroup(VcsLogSettings settings, VcsLogUiImpl ui) {
            this.mySettings = settings;
            this.myUi = ui;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new ToggleAction("Show Branches Panel"){

                public boolean isSelected(AnActionEvent e) {
                    return MySettingsActionGroup.this.mySettings.isShowBranchesPanel();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    MySettingsActionGroup.this.mySettings.setShowBranchesPanel(state);
                    MySettingsActionGroup.this.myUi.setBranchesPanelVisible(state);
                }
            }};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogQuickSettingsActions$MySettingsActionGroup", "getChildren"));
            }
            return anActionArray;
        }
    }
}

