/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Color REF_BORDER = JBColor.GRAY;
    private static final Color ROOT_INDICATOR_BORDER = JBColor.LIGHT_GRAY;
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.YELLOW, JBColor.LIGHT_GRAY, JBColor.BLUE, JBColor.MAGENTA, JBColor.CYAN, JBColor.GREEN, JBColor.ORANGE, JBColor.PINK};
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, Color> myRoots2Colors;

    public VcsLogColorManagerImpl(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "<init>"));
        }
        this.myRoots = new ArrayList<VirtualFile>(roots);
        Collections.sort(this.myRoots, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.myRoots2Colors = ContainerUtil.newHashMap();
        int i = 0;
        for (VirtualFile root : roots) {
            Color color;
            if (i >= ROOT_COLORS.length) {
                color = VcsLogColorManagerImpl.getDefaultRootColor();
            } else {
                color = ROOT_COLORS[i];
                ++i;
            }
            this.myRoots2Colors.put(root, color);
        }
    }

    @Override
    public boolean isMultipleRoots() {
        return this.myRoots.size() > 1;
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getRootColor"));
        }
        Color color = this.myRoots2Colors.get(root);
        if (color == null) {
            LOG.error("No color record for root " + root + ". All roots: " + this.myRoots2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        Color color2 = color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getRootColor"));
        }
        return color2;
    }

    private static Color getDefaultRootColor() {
        return UIUtil.getTableBackground();
    }

    @Override
    @NotNull
    public Color getReferenceBorderColor() {
        Color color = REF_BORDER;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getReferenceBorderColor"));
        }
        return color;
    }

    @Override
    @NotNull
    public Color getRootIndicatorBorder() {
        Color color = ROOT_INDICATOR_BORDER;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getRootIndicatorBorder"));
        }
        return color;
    }
}

