/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.PopupWithTextFieldWithAutoCompletion;
import java.util.Collection;
import java.util.List;

public class GoToRefAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        final VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VSC_LOG);
        if (project == null || log == null) {
            return;
        }
        List refs = ContainerUtil.map((Collection)log.getAllReferences(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
        final PopupWithTextFieldWithAutoCompletion textField = new PopupWithTextFieldWithAutoCompletion(project, refs);
        JBPopup popup = textField.createPopup();
        popup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                if (event.isOk()) {
                    log.jumpToReference(textField.getText());
                }
            }
        });
        popup.showUnderneathOf(log.getToolbar());
    }

    public void update(AnActionEvent e) {
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VSC_LOG);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log != null);
    }
}

