/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.layout;

import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.printmodel.layout.LayoutRow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MutableLayoutRow
implements LayoutRow {
    private final List<GraphElement> graphElements;
    private NodeRow nodeRow;

    public MutableLayoutRow() {
        this.graphElements = new LinkedList<GraphElement>();
    }

    public MutableLayoutRow(@NotNull LayoutRow layoutRow) {
        if (layoutRow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/MutableLayoutRow", "<init>"));
        }
        this.graphElements = new LinkedList<GraphElement>(layoutRow.getOrderedGraphElements());
        this.nodeRow = layoutRow.getGraphNodeRow();
    }

    @NotNull
    public List<GraphElement> getModifiableOrderedGraphElements() {
        List<GraphElement> list = this.graphElements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/MutableLayoutRow", "getModifiableOrderedGraphElements"));
        }
        return list;
    }

    public void setNodeRow(@NotNull NodeRow nodeRow) {
        if (nodeRow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/MutableLayoutRow", "setNodeRow"));
        }
        this.nodeRow = nodeRow;
    }

    @Override
    @NotNull
    public List<GraphElement> getOrderedGraphElements() {
        List<GraphElement> list = Collections.unmodifiableList(this.graphElements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/MutableLayoutRow", "getOrderedGraphElements"));
        }
        return list;
    }

    @Override
    public NodeRow getGraphNodeRow() {
        return this.nodeRow;
    }
}

