/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel.layout;

import com.intellij.vcs.log.compressedlist.CompressedList;
import com.intellij.vcs.log.compressedlist.RuntimeGenerateCompressedList;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.compressedlist.generator.Generator;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.printmodel.layout.LayoutRow;
import com.intellij.vcs.log.printmodel.layout.LayoutRowGenerator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LayoutModel {
    private final Graph graph;
    private CompressedList<LayoutRow> layoutRowCompressedList;
    private final Generator<LayoutRow> generator;

    public LayoutModel(@NotNull Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutModel", "<init>"));
        }
        this.graph = graph;
        this.generator = new LayoutRowGenerator(graph);
        this.build();
    }

    private void build() {
        List<NodeRow> rows = this.graph.getNodeRows();
        this.layoutRowCompressedList = new RuntimeGenerateCompressedList<LayoutRow>(this.generator, rows.size(), 100);
    }

    @NotNull
    public List<LayoutRow> getLayoutRows() {
        List<LayoutRow> list = this.layoutRowCompressedList.getList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printmodel/layout/LayoutModel", "getLayoutRows"));
        }
        return list;
    }

    public void recalculate(@NotNull UpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/layout/LayoutModel", "recalculate"));
        }
        this.layoutRowCompressedList.recalculate(updateRequest);
    }
}

