/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel;

import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectController {
    private final Set<GraphElement> selectedElements = new HashSet<GraphElement>();

    public void select(@Nullable GraphFragment fragment) {
        this.deselectAll();
        if (fragment == null) {
            return;
        }
        this.selectedElements.add(fragment.getUpNode());
        this.selectedElements.add(fragment.getDownNode());
        for (Edge edge : fragment.getUpNode().getDownEdges()) {
            this.selectedElements.add(edge);
        }
        this.selectedElements.addAll(fragment.getIntermediateNodes());
        for (Node node : fragment.getIntermediateNodes()) {
            for (Edge edge : node.getDownEdges()) {
                this.selectedElements.add(edge);
            }
        }
    }

    public void select(Set<GraphElement> selectedElements) {
        this.selectedElements.addAll(selectedElements);
    }

    public void deselectAll() {
        this.selectedElements.clear();
    }

    public boolean isSelected(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/SelectController", "isSelected"));
        }
        return this.selectedElements.contains(element);
    }
}

