/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printmodel;

import com.intellij.vcs.log.graph.elements.Node;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitSelectController {
    private final Set<Node> selectedNodes = new HashSet<Node>();
    private Node dragAndDropNode = null;
    private boolean above;

    public void selectDragAndDropNode(@Nullable Node node, boolean above) {
        this.dragAndDropNode = node;
        this.above = above;
    }

    public Node getDragAndDropNode() {
        return this.dragAndDropNode;
    }

    public boolean isAbove() {
        return this.above;
    }

    public void select(Set<Node> nodes) {
        this.selectedNodes.addAll(nodes);
    }

    public void deselectAll() {
        this.selectedNodes.clear();
    }

    public boolean isSelected(@NotNull Node element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/printmodel/CommitSelectController", "isSelected"));
        }
        return this.selectedNodes.contains(element);
    }
}

