/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render.cell;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.render.cell.AbstractGraphCellGenerator;
import com.intellij.vcs.log.newgraph.render.cell.EdgesInRow;
import com.intellij.vcs.log.newgraph.render.cell.ShortEdge;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphCellGeneratorImpl
extends AbstractGraphCellGenerator {
    private static final int LONG_EDGE_SIZE = 30;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int CACHE_SIZE = 100;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    protected final EdgesInRow myEdgesInRow;
    private final SLRUMap<Integer, List<GraphElement>> cache;
    private boolean showLongEdges;

    public GraphCellGeneratorImpl(@NotNull MutableGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "<init>"));
        }
        super(graph);
        this.cache = new SLRUMap(100, 200);
        this.showLongEdges = false;
        this.myEdgesInRow = new EdgesInRow(graph);
    }

    @Override
    protected int getCountVisibleElements(int visibleRowIndex) {
        return this.getSortedVisibleElementsInRow(visibleRowIndex).size();
    }

    @Override
    @NotNull
    protected List<ShortEdge> getDownShortEdges(int visibleRowIndex) {
        Function<Edge, Integer> endPosition = this.createEndPositionFunction(visibleRowIndex);
        ArrayList<ShortEdge> result = new ArrayList<ShortEdge>();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(visibleRowIndex);
        for (int startPosition = 0; startPosition < visibleElements.size(); ++startPosition) {
            Edge edge;
            int endPos;
            GraphElement element = visibleElements.get(startPosition);
            if (element instanceof Node) {
                Node node = (Node)element;
                for (Edge edge2 : node.getDownEdges()) {
                    int endPos2 = (Integer)endPosition.fun((Object)edge2);
                    if (endPos2 == -1) continue;
                    result.add(new ShortEdge(edge2, startPosition, endPos2));
                }
            }
            if (!(element instanceof Edge) || (endPos = ((Integer)endPosition.fun((Object)(edge = (Edge)element))).intValue()) == -1) continue;
            result.add(new ShortEdge(edge, startPosition, endPos));
        }
        ArrayList<ShortEdge> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "getDownShortEdges"));
        }
        return arrayList;
    }

    @NotNull
    private Function<Edge, Integer> createEndPositionFunction(int visibleRowIndex) {
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex + 1);
        final HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>();
        for (int position = 0; position < visibleElementsInNextRow.size(); ++position) {
            toPosition.put(visibleElementsInNextRow.get(position), position);
        }
        Function<Edge, Integer> function = new Function<Edge, Integer>(){

            public Integer fun(Edge edge) {
                int downNodeVisibleIndex;
                Integer position = (Integer)toPosition.get(edge);
                if (position == null && (downNodeVisibleIndex = edge.getDownNodeVisibleIndex()) != Integer.MAX_VALUE) {
                    position = (Integer)toPosition.get(GraphCellGeneratorImpl.this.myGraph.getNode(downNodeVisibleIndex));
                }
                if (position == null) {
                    return -1;
                }
                return position;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "createEndPositionFunction"));
        }
        return function;
    }

    @Override
    @NotNull
    protected List<SpecialRowElement> getSpecialElements(int visibleRowIndex) {
        SmartList result = new SmartList();
        int position = 0;
        for (GraphElement element : this.getSortedVisibleElementsInRow(visibleRowIndex)) {
            if (element instanceof Node) {
                result.add(new SpecialRowElement(element, position, SpecialRowElement.Type.NODE));
            }
            if (element instanceof Edge) {
                Edge edge = (Edge)element;
                int edgeSize = edge.getDownNodeVisibleIndex() - edge.getUpNodeVisibleIndex();
                int upOffset = visibleRowIndex - edge.getUpNodeVisibleIndex();
                int downOffset = edge.getDownNodeVisibleIndex() - visibleRowIndex;
                if (edgeSize >= 30) {
                    if (!this.showLongEdges) {
                        GraphCellGeneratorImpl.addArrowIfNeeded((List<SpecialRowElement>)result, position, edge, upOffset, downOffset, 1);
                    } else {
                        GraphCellGeneratorImpl.addArrowIfNeeded((List<SpecialRowElement>)result, position, edge, upOffset, downOffset, 1);
                        if (edgeSize >= 1000) {
                            GraphCellGeneratorImpl.addArrowIfNeeded((List<SpecialRowElement>)result, position, edge, upOffset, downOffset, 250);
                        }
                    }
                }
            }
            ++position;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "getSpecialElements"));
        }
        return smartList;
    }

    private static void addArrowIfNeeded(List<SpecialRowElement> result, int position, Edge edge, int upOffset, int downOffset, int edgePartSize) {
        if (upOffset == edgePartSize) {
            result.add(new SpecialRowElement(edge, position, SpecialRowElement.Type.DOWN_ARROW));
        }
        if (downOffset == edgePartSize) {
            result.add(new SpecialRowElement(edge, position, SpecialRowElement.Type.UP_ARROW));
        }
    }

    @Override
    public boolean isShowLongEdges() {
        return this.showLongEdges;
    }

    @Override
    public void setShowLongEdges(boolean showLongEdges) {
        this.showLongEdges = showLongEdges;
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.myEdgesInRow.invalidate();
        this.cache.clear();
    }

    private int getLongEdgeSize() {
        if (this.showLongEdges) {
            return 1000;
        }
        return 30;
    }

    private int getEdgeShowPartSize() {
        if (this.showLongEdges) {
            return 250;
        }
        return 1;
    }

    private boolean edgeIsVisibleInRow(@NotNull Edge edge, int visibleRowIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "edgeIsVisibleInRow"));
        }
        int edgeSize = edge.getDownNodeVisibleIndex() - edge.getUpNodeVisibleIndex();
        if (edgeSize < this.getLongEdgeSize()) {
            return true;
        }
        return visibleRowIndex - edge.getUpNodeVisibleIndex() <= this.getEdgeShowPartSize() || edge.getDownNodeVisibleIndex() - visibleRowIndex <= this.getEdgeShowPartSize();
    }

    @NotNull
    private List<GraphElement> getSortedVisibleElementsInRow(int visibleRowIndex) {
        List graphElements = (List)this.cache.get((Object)visibleRowIndex);
        if (graphElements != null) {
            List list = graphElements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "getSortedVisibleElementsInRow"));
            }
            return list;
        }
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        result.add(this.myGraph.getNode(visibleRowIndex));
        for (Edge edge : this.myEdgesInRow.getEdgesInRow(visibleRowIndex)) {
            if (!this.edgeIsVisibleInRow(edge, visibleRowIndex)) continue;
            result.add(edge);
        }
        Collections.sort(result, new Comparator<GraphElement>(){

            @Override
            public int compare(@NotNull GraphElement o1, @NotNull GraphElement o2) {
                int layoutIndex2;
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl$2", "compare"));
                }
                int layoutIndex1 = o1.getLayoutIndex();
                if (layoutIndex1 != (layoutIndex2 = o2.getLayoutIndex())) {
                    return layoutIndex1 - layoutIndex2;
                }
                if (o1 instanceof Node) {
                    return 1;
                }
                if (o2 instanceof Node) {
                    return -1;
                }
                if (o1 instanceof Edge && o2 instanceof Edge) {
                    Edge edge1 = (Edge)o1;
                    Edge edge2 = (Edge)o2;
                    if (edge1.getUpNodeVisibleIndex() != edge2.getUpNodeVisibleIndex()) {
                        return edge1.getUpNodeVisibleIndex() - edge2.getUpNodeVisibleIndex();
                    }
                    return edge2.getDownNodeVisibleIndex() - edge1.getDownNodeVisibleIndex();
                }
                return 0;
            }
        });
        this.cache.put((Object)visibleRowIndex, result);
        ArrayList<GraphElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/render/cell/GraphCellGeneratorImpl", "getSortedVisibleElementsInRow"));
        }
        return arrayList;
    }
}

