/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render.cell;

import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.render.GraphCellGenerator;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import com.intellij.vcs.log.newgraph.render.cell.ShortEdge;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGraphCellGenerator
implements GraphCellGenerator {
    @NotNull
    protected final MutableGraph myGraph;

    protected AbstractGraphCellGenerator(@NotNull MutableGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/cell/AbstractGraphCellGenerator", "<init>"));
        }
        this.myGraph = graph;
    }

    @Override
    public int getCountVisibleRow() {
        return this.myGraph.getCountVisibleNodes();
    }

    @Override
    public GraphCell getGraphCell(int visibleRowIndex) {
        List<Object> downShortEdges = visibleRowIndex == this.getCountVisibleRow() - 1 ? Collections.emptyList() : this.getDownShortEdges(visibleRowIndex);
        List<Object> upShortEdges = visibleRowIndex == 0 ? Collections.emptyList() : this.getDownShortEdges(visibleRowIndex - 1);
        return new GraphCell(this.getCountVisibleElements(visibleRowIndex), this.getSpecialElements(visibleRowIndex), upShortEdges, downShortEdges);
    }

    protected abstract int getCountVisibleElements(int var1);

    @NotNull
    protected abstract List<ShortEdge> getDownShortEdges(int var1);

    @NotNull
    protected abstract List<SpecialRowElement> getSpecialElements(int var1);
}

