/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.render;

import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import com.intellij.vcs.log.newgraph.render.cell.ShortEdge;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionUtil {
    private static float distance(int x1, int y1, int x2, int y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static boolean overUpEdge(ShortEdge edge, int x, int y) {
        float thick = 1.5f;
        int x1 = 15 * edge.getDownPosition() + 7;
        int y1 = 11;
        int x2 = 15 * edge.getUpPosition() + 7;
        int y2 = -11;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + thick;
    }

    public static boolean overDownEdge(ShortEdge edge, int x, int y) {
        float thick = 1.5f;
        int x1 = 15 * edge.getUpPosition() + 7;
        int y1 = 11;
        int x2 = 15 * edge.getDownPosition() + 7;
        int y2 = 33;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + thick;
    }

    public static boolean overNode(int position, int x, int y) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        return PositionUtil.distance(x0, y0, x, y) <= (float)r;
    }

    public static int getYInsideRow(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/PositionUtil", "getYInsideRow"));
        }
        return point.y - PositionUtil.getRowIndex(point) * 22;
    }

    public static int getRowIndex(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/render/PositionUtil", "getRowIndex"));
        }
        return point.y / 22;
    }

    @Nullable
    public static Node getNode(@Nullable GraphCell cell) {
        if (cell == null) {
            return null;
        }
        for (SpecialRowElement element : cell.getSpecialRowElements()) {
            GraphElement graphElement = element.getElement();
            if (!(graphElement instanceof Node)) continue;
            return (Node)graphElement;
        }
        return null;
    }
}

