/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.impl;

import com.intellij.vcs.log.GraphCommit;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.List;

public class DuplicateParentFixer {
    public static AbstractList<GraphCommit> fixDuplicateParentCommits(final List<? extends GraphCommit> finalCommits) {
        return new AbstractList<GraphCommit>(){

            @Override
            public GraphCommit get(int index) {
                final GraphCommit commit = (GraphCommit)finalCommits.get(index);
                return new GraphCommit(){

                    @Override
                    public int getIndex() {
                        return commit.getIndex();
                    }

                    @Override
                    public int[] getParentIndices() {
                        return DuplicateParentFixer.fixParentsDuplicate(commit.getParentIndices());
                    }
                };
            }

            @Override
            public int size() {
                return finalCommits.size();
            }
        };
    }

    private static int[] fixParentsDuplicate(int[] commitParents) {
        if (commitParents.length == 1) {
            return commitParents;
        }
        if (commitParents.length == 2) {
            if (commitParents[0] != commitParents[1]) {
                return commitParents;
            }
            return new int[]{commitParents[0]};
        }
        HashSet<Integer> hashes = new HashSet<Integer>();
        for (int hashIndex : commitParents) {
            hashes.add(hashIndex);
        }
        if (hashes.size() == commitParents.length) {
            return commitParents;
        }
        int[] newCommitParents = new int[hashes.size()];
        int offset = 0;
        for (int hashIndex : commitParents) {
            if (!hashes.remove(hashIndex)) continue;
            newCommitParents[offset] = hashIndex;
            ++offset;
        }
        return newCommitParents;
    }
}

