/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphWithElementsInfo;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.ThickHoverController;
import com.intellij.vcs.log.newgraph.gpaph.actions.InternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.impl.MutableGraphWithHiddenNodes;
import com.intellij.vcs.log.newgraph.utils.impl.IDIntToInt;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermanentAsMutableGraph
extends MutableGraphWithHiddenNodes<GraphWithElementsInfoImpl> {
    @NotNull
    private final ThickHoverController myThickHoverController;

    public PermanentAsMutableGraph(@NotNull PermanentGraph graph, @NotNull PermanentGraphLayout layout, @NotNull ThickHoverController thickHoverController) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph", "<init>"));
        }
        if (thickHoverController == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph", "<init>"));
        }
        super(new IDIntToInt(graph.nodesCount()), new GraphWithElementsInfoImpl(graph), layout);
        this.myThickHoverController = thickHoverController;
    }

    @Override
    public int performAction(@NotNull InternalGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph", "performAction"));
        }
        return -1;
    }

    @Override
    @NotNull
    public ThickHoverController getThickHoverController() {
        ThickHoverController thickHoverController = this.myThickHoverController;
        if (thickHoverController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph", "getThickHoverController"));
        }
        return thickHoverController;
    }

    protected static class GraphWithElementsInfoImpl
    implements GraphWithElementsInfo {
        private final PermanentGraph myGraph;

        private GraphWithElementsInfoImpl(PermanentGraph graph) {
            this.myGraph = graph;
        }

        @Override
        @NotNull
        public Node.Type getNodeType(int nodeIndex) {
            Node.Type type = Node.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph$GraphWithElementsInfoImpl", "getNodeType"));
            }
            return type;
        }

        @Override
        @NotNull
        public Edge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
            Edge.Type type = Edge.Type.USUAL;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph$GraphWithElementsInfoImpl", "getEdgeType"));
            }
            return type;
        }

        @Override
        public int nodesCount() {
            return this.myGraph.nodesCount();
        }

        @Override
        @NotNull
        public List<Integer> getUpNodes(int nodeIndex) {
            List<Integer> list = this.myGraph.getUpNodes(nodeIndex);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph$GraphWithElementsInfoImpl", "getUpNodes"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<Integer> getDownNodes(int nodeIndex) {
            List<Integer> list = this.myGraph.getDownNodes(nodeIndex);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/PermanentAsMutableGraph$GraphWithElementsInfoImpl", "getDownNodes"));
            }
            return list;
        }
    }
}

