/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.GraphWithElementsInfo;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.impl.EdgeImpl;
import com.intellij.vcs.log.newgraph.gpaph.impl.NodeImpl;
import com.intellij.vcs.log.newgraph.utils.IntToIntMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MutableGraphWithHiddenNodes<T extends GraphWithElementsInfo>
implements MutableGraph {
    @NotNull
    protected final IntToIntMap myVisibleToReal;
    @NotNull
    protected final T myGraph;
    @NotNull
    protected final PermanentGraphLayout myLayout;

    @Nullable
    public static Edge containedCollapsedEdge(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "containedCollapsedEdge"));
        }
        if (element instanceof Edge) {
            Edge edge = (Edge)element;
            if (edge.getType() == Edge.Type.HIDE_FRAGMENT) {
                return edge;
            }
        } else {
            Node node = (Node)element;
            for (Edge upEdge : node.getUpEdges()) {
                if (upEdge.getType() != Edge.Type.HIDE_FRAGMENT) continue;
                return upEdge;
            }
            for (Edge downEdge : node.getDownEdges()) {
                if (downEdge.getType() != Edge.Type.HIDE_FRAGMENT) continue;
                return downEdge;
            }
        }
        return null;
    }

    protected MutableGraphWithHiddenNodes(@NotNull IntToIntMap visibleToReal, @NotNull T graph, @NotNull PermanentGraphLayout layout) {
        if (visibleToReal == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "<init>"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "<init>"));
        }
        this.myVisibleToReal = visibleToReal;
        this.myGraph = graph;
        this.myLayout = layout;
    }

    @Override
    public int getCountVisibleNodes() {
        return this.myVisibleToReal.shortSize();
    }

    @Override
    @NotNull
    public Node getNode(int visibleNodeIndex) {
        int nodeIndex = this.toNodeIndex(visibleNodeIndex);
        List<Edge> upEdges = this.convertToEdgeList(this.myGraph.getUpNodes(nodeIndex), nodeIndex, true);
        List<Edge> downEdges = this.convertToEdgeList(this.myGraph.getDownNodes(nodeIndex), nodeIndex, false);
        Node.Type nodeType = this.myGraph.getNodeType(nodeIndex);
        int nodeLayoutIndex = this.myLayout.getLayoutIndex(nodeIndex);
        NodeImpl nodeImpl = new NodeImpl(visibleNodeIndex, nodeType, upEdges, downEdges, nodeLayoutIndex);
        if (nodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "getNode"));
        }
        return nodeImpl;
    }

    @Override
    public int getIndexInPermanentGraph(int visibleNodeIndex) {
        return this.toNodeIndex(visibleNodeIndex);
    }

    public int toVisibleIndex(int nodeIndexInPermanentGraph) {
        if (nodeIndexInPermanentGraph == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.myVisibleToReal.getShortIndex(nodeIndexInPermanentGraph);
    }

    protected int toNodeIndex(int visibleNodeIndex) {
        if (visibleNodeIndex == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.myVisibleToReal.getLongIndex(visibleNodeIndex);
    }

    @NotNull
    private List<Edge> convertToEdgeList(@NotNull List<Integer> destinationNodeIndexes, int startNodeIndex, boolean toUp) {
        if (destinationNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "convertToEdgeList"));
        }
        SmartList result = new SmartList();
        for (int destinationIndex : destinationNodeIndexes) {
            int downNodeIndex;
            int upNodeIndex;
            if (toUp) {
                upNodeIndex = destinationIndex;
                downNodeIndex = startNodeIndex;
            } else {
                downNodeIndex = destinationIndex;
                upNodeIndex = startNodeIndex;
            }
            Edge.Type type = this.myGraph.getEdgeType(upNodeIndex, downNodeIndex);
            int layoutIndex = this.getEdgeLayoutIndex(upNodeIndex, downNodeIndex);
            result.add(new EdgeImpl(this.toVisibleIndex(upNodeIndex), this.toVisibleIndex(downNodeIndex), type, layoutIndex));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/MutableGraphWithHiddenNodes", "convertToEdgeList"));
        }
        return smartList;
    }

    private int getEdgeLayoutIndex(int upNodeIndex, int downNodeIndex) {
        if (downNodeIndex == Integer.MAX_VALUE) {
            return this.myLayout.getLayoutIndex(upNodeIndex);
        }
        int upNodeLayoutIndex = this.myLayout.getLayoutIndex(upNodeIndex);
        int downNodeLayoutIndex = this.myLayout.getLayoutIndex(downNodeIndex);
        return Math.max(upNodeLayoutIndex, downNodeLayoutIndex);
    }
}

