/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.impl;

import com.intellij.vcs.log.newgraph.gpaph.Edge;
import org.jetbrains.annotations.NotNull;

public class EdgeImpl
implements Edge {
    private final int myUpVisibleIndex;
    private final int myDownVisibleIndex;
    @NotNull
    private final Edge.Type myType;
    private final int myLayoutIndex;

    public EdgeImpl(int upVisibleIndex, int downVisibleIndex, @NotNull Edge.Type type, int layoutIndex) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/gpaph/impl/EdgeImpl", "<init>"));
        }
        this.myUpVisibleIndex = upVisibleIndex;
        this.myDownVisibleIndex = downVisibleIndex;
        this.myType = type;
        this.myLayoutIndex = layoutIndex;
    }

    @Override
    public int getUpNodeVisibleIndex() {
        return this.myUpVisibleIndex;
    }

    @Override
    public int getDownNodeVisibleIndex() {
        return this.myDownVisibleIndex;
    }

    @Override
    @NotNull
    public Edge.Type getType() {
        Edge.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/gpaph/impl/EdgeImpl", "getType"));
        }
        return type;
    }

    @Override
    public int getLayoutIndex() {
        return this.myLayoutIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeImpl)) {
            return false;
        }
        EdgeImpl edge = (EdgeImpl)o;
        if (this.myDownVisibleIndex != edge.myDownVisibleIndex) {
            return false;
        }
        if (this.myLayoutIndex != edge.myLayoutIndex) {
            return false;
        }
        if (this.myUpVisibleIndex != edge.myUpVisibleIndex) {
            return false;
        }
        return this.myType == edge.myType;
    }

    public int hashCode() {
        int result = this.myUpVisibleIndex;
        result = 31 * result + this.myDownVisibleIndex;
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myLayoutIndex;
        return result;
    }
}

