/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.gpaph.fragments;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.Node;
import com.intellij.vcs.log.newgraph.gpaph.fragments.GraphFragment;
import com.intellij.vcs.log.newgraph.gpaph.impl.CollapsedMutableGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    private static final int SHORT_FRAGMENT_MAX_SIZE = 100;
    private static final int MAX_SEARCH_SIZE = 10;
    @NotNull
    private final CollapsedMutableGraph myMutableGraph;
    @NotNull
    private final Set<Integer> myBranchNodeIndexes;
    private final Function<Integer, List<Integer>> upNodesFun;
    private final Function<Integer, List<Integer>> downNodesFun;
    private final Function<Integer, Boolean> thisNodeCantBeInMiddle;

    public FragmentGenerator(@NotNull CollapsedMutableGraph mutableGraph, @NotNull Set<Integer> branchNodeIndexes) {
        if (mutableGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/fragments/FragmentGenerator", "<init>"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/gpaph/fragments/FragmentGenerator", "<init>"));
        }
        this.upNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return FragmentGenerator.this.myMutableGraph.getInternalGraph().getUpNodes(integer);
            }
        };
        this.downNodesFun = new Function<Integer, List<Integer>>(){

            public List<Integer> fun(Integer integer) {
                return FragmentGenerator.this.myMutableGraph.getInternalGraph().getDownNodes(integer);
            }
        };
        this.thisNodeCantBeInMiddle = new Function<Integer, Boolean>(){

            public Boolean fun(Integer integer) {
                return FragmentGenerator.this.myBranchNodeIndexes.contains(integer);
            }
        };
        this.myMutableGraph = mutableGraph;
        this.myBranchNodeIndexes = branchNodeIndexes;
    }

    @Nullable
    public GraphFragment getRelativeFragment(@NotNull GraphElement element) {
        int downVisibleIndex;
        Node upNode;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/fragments/FragmentGenerator", "getRelativeFragment"));
        }
        if (element instanceof Node) {
            upNode = (Node)element;
            downVisibleIndex = upNode.getVisibleNodeIndex();
        } else {
            Edge edge = (Edge)element;
            upNode = this.myMutableGraph.getNode(edge.getUpNodeVisibleIndex());
            downVisibleIndex = edge.getDownNodeVisibleIndex();
        }
        for (int i = 0; i < 10; ++i) {
            GraphFragment graphFragment = this.getDownFragment(upNode.getVisibleNodeIndex());
            if (graphFragment != null && graphFragment.downVisibleNodeIndex >= downVisibleIndex) {
                return graphFragment;
            }
            if (upNode.getUpEdges().size() != 1) break;
            upNode = this.myMutableGraph.getNode(upNode.getUpEdges().get(0).getUpNodeVisibleIndex());
        }
        return null;
    }

    @Nullable
    public GraphFragment getDownFragment(int upperVisibleNodeIndex) {
        Pair<Integer, Integer> fragment = FragmentGenerator.getFragment(this.myMutableGraph.getIndexInPermanentGraph(upperVisibleNodeIndex), this.downNodesFun, this.upNodesFun, this.thisNodeCantBeInMiddle);
        return fragment == null ? null : new GraphFragment(this.myMutableGraph.toVisibleIndex((Integer)fragment.first), this.myMutableGraph.toVisibleIndex((Integer)fragment.second));
    }

    @Nullable
    public GraphFragment getUpFragment(int lowerNodeIndex) {
        Pair<Integer, Integer> fragment = FragmentGenerator.getFragment(this.myMutableGraph.getIndexInPermanentGraph(lowerNodeIndex), this.upNodesFun, this.downNodesFun, this.thisNodeCantBeInMiddle);
        return fragment == null ? null : new GraphFragment(this.myMutableGraph.toVisibleIndex((Integer)fragment.second), this.myMutableGraph.toVisibleIndex((Integer)fragment.first));
    }

    @Nullable
    public GraphFragment getLongDownFragment(int rowIndex) {
        return this.getLongFragment(this.getDownFragment(rowIndex), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/fragments/FragmentGenerator", "getLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), Integer.MAX_VALUE);
    }

    @Nullable
    public GraphFragment getPartLongFragment(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/gpaph/fragments/FragmentGenerator", "getPartLongFragment"));
        }
        return this.getLongFragment(this.getRelativeFragment(element), 500);
    }

    @Nullable
    private GraphFragment getLongFragment(@Nullable GraphFragment startFragment, int bound) {
        GraphFragment shortFragment;
        if (startFragment == null) {
            return null;
        }
        int maxDown = startFragment.downVisibleNodeIndex;
        while ((shortFragment = this.getDownFragment(maxDown)) != null && !this.myBranchNodeIndexes.contains(this.myMutableGraph.getIndexInPermanentGraph(maxDown)) && (maxDown = shortFragment.downVisibleNodeIndex) - startFragment.downVisibleNodeIndex <= bound) {
        }
        int maxUp = startFragment.upVisibleNodeIndex;
        while ((shortFragment = this.getUpFragment(maxUp)) != null && !this.myBranchNodeIndexes.contains(this.myMutableGraph.getIndexInPermanentGraph(maxUp)) && startFragment.upVisibleNodeIndex - (maxUp = shortFragment.upVisibleNodeIndex) <= bound) {
        }
        if (maxUp != startFragment.upVisibleNodeIndex || maxDown != startFragment.downVisibleNodeIndex) {
            return new GraphFragment(maxUp, maxDown);
        }
        if (this.myMutableGraph.getNode(startFragment.upVisibleNodeIndex).getDownEdges().size() != 1) {
            return startFragment;
        }
        return null;
    }

    @Nullable
    private static Pair<Integer, Integer> getFragment(int startNode, Function<Integer, List<Integer>> getNextNodes, Function<Integer, List<Integer>> getPrevNodes, Function<Integer, Boolean> thisNodeCantBeInMiddle) {
        HashSet<Integer> blackNodes = new HashSet<Integer>();
        blackNodes.add(startNode);
        HashSet grayNodes = new HashSet();
        grayNodes.addAll((Collection)getNextNodes.fun((Object)startNode));
        int endNode = -1;
        while (blackNodes.size() < 100 && !grayNodes.contains(Integer.MAX_VALUE)) {
            int nextBlackNode = -1;
            Iterator i$ = grayNodes.iterator();
            while (i$.hasNext()) {
                int grayNode = (Integer)i$.next();
                if (!blackNodes.containsAll((Collection)getPrevNodes.fun((Object)grayNode))) continue;
                nextBlackNode = grayNode;
                break;
            }
            if (nextBlackNode == -1) {
                return null;
            }
            if (grayNodes.size() == 1) {
                endNode = nextBlackNode;
                break;
            }
            List nextGrayNodes = (List)getNextNodes.fun((Object)nextBlackNode);
            if (nextGrayNodes.isEmpty() || ((Boolean)thisNodeCantBeInMiddle.fun((Object)nextBlackNode)).booleanValue()) {
                return null;
            }
            blackNodes.add(nextBlackNode);
            grayNodes.remove(nextBlackNode);
            grayNodes.addAll(nextGrayNodes);
        }
        if (endNode != -1) {
            return Pair.create((Object)startNode, (Object)endNode);
        }
        return null;
    }
}

