/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.graph.GraphAction;
import com.intellij.vcs.log.graph.GraphAnswer;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.graph.GraphInfoProvider;
import com.intellij.vcs.log.graph.PaintInfo;
import com.intellij.vcs.log.newgraph.GraphFlags;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.facade.GraphActionDispatcher;
import com.intellij.vcs.log.newgraph.facade.GraphData;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.impl.PermanentGraphBuilder;
import com.intellij.vcs.log.newgraph.impl.PermanentGraphImpl;
import com.intellij.vcs.log.newgraph.impl.PermanentGraphLayoutBuilder;
import com.intellij.vcs.log.newgraph.render.ElementColorManager;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphFacadeImpl
implements GraphFacade {
    @NotNull
    private final GraphData myGraphData;
    @NotNull
    private final GraphActionDispatcher myActionDispatcher;

    @NotNull
    public static GraphFacadeImpl newInstance(@NotNull List<? extends GraphCommit> commits, @NotNull Set<Integer> branchCommitHashIndexes, final @NotNull GraphColorManager colorManager) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "newInstance"));
        }
        if (branchCommitHashIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "newInstance"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "newInstance"));
        }
        GraphFlags flags = new GraphFlags(commits.size());
        Pair<PermanentGraphImpl, Map<Integer, GraphCommit>> graphAndUnderdoneCommits = PermanentGraphBuilder.build(flags.getSimpleNodeFlags(), commits);
        final PermanentGraphImpl permanentGraph = (PermanentGraphImpl)graphAndUnderdoneCommits.first;
        DfsUtil dfsUtil = new DfsUtil(commits.size());
        final PermanentGraphLayout graphLayout = PermanentGraphLayoutBuilder.build(dfsUtil, permanentGraph, new Comparator<Integer>(){

            @Override
            public int compare(@NotNull Integer o1, @NotNull Integer o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$1", "compare"));
                }
                int hashIndex1 = permanentGraph.getHashIndex(o1);
                int hashIndex2 = permanentGraph.getHashIndex(o2);
                return colorManager.compareHeads(hashIndex1, hashIndex2);
            }
        });
        ElementColorManager elementColorManager = new ElementColorManager(){

            @Override
            @NotNull
            public JBColor getColor(@NotNull GraphElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$2", "getColor"));
                }
                int headNodeIndex = graphLayout.getHeadNodeIndex(element.getLayoutIndex());
                int headHashIndex = permanentGraph.getHashIndex(headNodeIndex);
                int baseLayoutIndex = graphLayout.getStartLayout(element.getLayoutIndex());
                if (baseLayoutIndex == element.getLayoutIndex()) {
                    JBColor jBColor = colorManager.getColorOfBranch(headHashIndex);
                    if (jBColor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$2", "getColor"));
                    }
                    return jBColor;
                }
                JBColor jBColor = colorManager.getColorOfFragment(headHashIndex, element.getLayoutIndex());
                if (jBColor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$2", "getColor"));
                }
                return jBColor;
            }
        };
        HashSet<Integer> branchNodeIndexes = new HashSet<Integer>();
        for (int i = 0; i < permanentGraph.nodesCount(); ++i) {
            if (!branchCommitHashIndexes.contains(permanentGraph.getHashIndex(i))) continue;
            branchNodeIndexes.add(i);
        }
        GraphData graphData = new GraphData(flags, permanentGraph, (Map)graphAndUnderdoneCommits.second, graphLayout, elementColorManager, dfsUtil, branchNodeIndexes);
        GraphFacadeImpl graphFacadeImpl = new GraphFacadeImpl(graphData);
        if (graphFacadeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "newInstance"));
        }
        return graphFacadeImpl;
    }

    public GraphFacadeImpl(@NotNull GraphData graphData) {
        if (graphData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "<init>"));
        }
        this.myGraphData = graphData;
        this.myActionDispatcher = new GraphActionDispatcher(graphData);
    }

    @NotNull
    public PaintInfo paint(int visibleRow) {
        this.myGraphData.assertRange(visibleRow);
        PaintInfo paintInfo = this.myGraphData.getGraphRender().paint(visibleRow);
        if (paintInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "paint"));
        }
        return paintInfo;
    }

    @Nullable
    public GraphAnswer performAction(@NotNull GraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "performAction"));
        }
        return this.myActionDispatcher.performAction(action);
    }

    @NotNull
    public List<Integer> getAllCommits() {
        throw new UnsupportedOperationException();
    }

    public int getCommitAtRow(int visibleRow) {
        this.myGraphData.assertRange(visibleRow);
        int indexInPermanentGraph = this.myGraphData.getMutableGraph().getIndexInPermanentGraph(visibleRow);
        return this.myGraphData.getPermanentGraph().getHashIndex(indexInPermanentGraph);
    }

    public int getVisibleCommitCount() {
        return this.myGraphData.getCountVisibleNodes();
    }

    public void setVisibleBranches(@Nullable Collection<Integer> heads) {
        this.myGraphData.setVisibleBranches(heads);
    }

    public void setFilter(@Nullable Condition<Integer> visibilityPredicate) {
        this.myGraphData.setFilter(visibilityPredicate);
    }

    @NotNull
    public GraphInfoProvider getInfoProvider() {
        GraphInfoProvider graphInfoProvider = new GraphInfoProvider(){

            @NotNull
            public Set<Integer> getContainingBranches(int visibleRow) {
                GraphFacadeImpl.this.myGraphData.assertRange(visibleRow);
                Set<Integer> set = GraphFacadeImpl.this.myGraphData.getContainingBranchesGetter().getBranchHashIndexes(GraphFacadeImpl.this.myGraphData.getMutableGraph().getIndexInPermanentGraph(visibleRow));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$3", "getContainingBranches"));
                }
                return set;
            }

            @NotNull
            public GraphInfoProvider.RowInfo getRowInfo(int visibleRow) {
                GraphFacadeImpl.this.myGraphData.assertRange(visibleRow);
                int indexInPermanentGraph = GraphFacadeImpl.this.myGraphData.getMutableGraph().getIndexInPermanentGraph(visibleRow);
                final int oneOfHeadNodeIndex = GraphFacadeImpl.this.myGraphData.getPermanentGraphLayout().getOneOfHeadNodeIndex(indexInPermanentGraph);
                GraphInfoProvider.RowInfo rowInfo = new GraphInfoProvider.RowInfo(){

                    public int getOneOfHeads() {
                        return GraphFacadeImpl.this.myGraphData.getPermanentGraph().getHashIndex(oneOfHeadNodeIndex);
                    }
                };
                if (rowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl$3", "getRowInfo"));
                }
                return rowInfo;
            }

            public boolean areLongEdgesHidden() {
                return !GraphFacadeImpl.this.myGraphData.getGraphRender().isShowLongEdges();
            }
        };
        if (graphInfoProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphFacadeImpl", "getInfoProvider"));
        }
        return graphInfoProvider;
    }
}

