/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.newgraph.GraphFlags;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.PermanentGraphLayout;
import com.intellij.vcs.log.newgraph.facade.ContainingBranchesGetter;
import com.intellij.vcs.log.newgraph.facade.CurrentBranches;
import com.intellij.vcs.log.newgraph.gpaph.MutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.impl.CollapsedMutableGraph;
import com.intellij.vcs.log.newgraph.gpaph.impl.FilterMutableGraph;
import com.intellij.vcs.log.newgraph.render.ElementColorManager;
import com.intellij.vcs.log.newgraph.render.GraphRender;
import com.intellij.vcs.log.newgraph.render.cell.FilterGraphCellGenerator;
import com.intellij.vcs.log.newgraph.render.cell.GraphCellGeneratorImpl;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphData {
    @NotNull
    private final GraphFlags myGraphFlags;
    @NotNull
    private final PermanentGraph myPermanentGraph;
    @NotNull
    private final Map<Integer, GraphCommit> myCommitsWithNotLoadParentMap;
    @NotNull
    private final PermanentGraphLayout myPermanentGraphLayout;
    @NotNull
    private final DfsUtil myDfsUtil;
    @NotNull
    private final ElementColorManager myColorManager;
    @NotNull
    private final Set<Integer> myBranchNodeIndexes;
    @NotNull
    private final CurrentBranches myCurrentBranches;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private MutableGraph myMutableGraph;
    @NotNull
    private GraphRender myGraphRender;
    @Nullable
    private Set<Integer> myHeads;
    @Nullable
    private Condition<Integer> myVisibilityPredicate;

    public GraphData(@NotNull GraphFlags graphFlags, @NotNull PermanentGraph permanentGraph, @NotNull Map<Integer, GraphCommit> commitsWithNotLoadParentMap, @NotNull PermanentGraphLayout permanentGraphLayout, @NotNull ElementColorManager colorManager, @NotNull DfsUtil dfsUtil, @NotNull Set<Integer> branchNodeIndexes) {
        if (graphFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (commitsWithNotLoadParentMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (permanentGraphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/vcs/log/newgraph/facade/GraphData", "<init>"));
        }
        this.myHeads = null;
        this.myVisibilityPredicate = null;
        this.myGraphFlags = graphFlags;
        this.myPermanentGraph = permanentGraph;
        this.myCommitsWithNotLoadParentMap = commitsWithNotLoadParentMap;
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myColorManager = colorManager;
        this.myDfsUtil = dfsUtil;
        this.myBranchNodeIndexes = branchNodeIndexes;
        this.myCurrentBranches = new CurrentBranches(permanentGraph, graphFlags.getVisibleNodesInBranches(), dfsUtil);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this.myPermanentGraph, branchNodeIndexes, dfsUtil, graphFlags.getTempFlags());
        this.applyFilters();
    }

    public void setVisibleBranches(@Nullable Collection<Integer> heads) {
        this.myHeads = heads == null ? null : new HashSet(heads);
        this.applyFilters();
    }

    public void setFilter(@Nullable Condition<Integer> visibilityPredicate) {
        this.myVisibilityPredicate = visibilityPredicate;
        this.applyFilters();
    }

    private void applyFilters() {
        this.myCurrentBranches.setVisibleBranches(this.myHeads);
        if (this.myVisibilityPredicate == null) {
            this.myMutableGraph = CollapsedMutableGraph.newInstance(this.myPermanentGraph, this.myPermanentGraphLayout, this.myGraphFlags, this.myBranchNodeIndexes, this.myDfsUtil);
            GraphCellGeneratorImpl cellGenerator = new GraphCellGeneratorImpl(this.myMutableGraph);
            this.myGraphRender = new GraphRender(this.myMutableGraph, this.myColorManager, cellGenerator);
        } else {
            Condition<Integer> isVisibleNode = new Condition<Integer>(){

                public boolean value(Integer integer) {
                    return GraphData.this.myVisibilityPredicate.value((Object)GraphData.this.myPermanentGraph.getHashIndex(integer));
                }
            };
            FilterMutableGraph filterMutableGraph = FilterMutableGraph.newInstance(this.myPermanentGraph, this.myPermanentGraphLayout, this.myGraphFlags.getVisibleNodesInBranches(), this.myGraphFlags.getFlagsForFilters(), isVisibleNode);
            this.myMutableGraph = filterMutableGraph;
            FilterGraphCellGenerator filterGraphCellGenerator = new FilterGraphCellGenerator(filterMutableGraph);
            this.myGraphRender = new GraphRender(this.myMutableGraph, this.myColorManager, filterGraphCellGenerator);
        }
    }

    @NotNull
    public PermanentGraph getPermanentGraph() {
        PermanentGraph permanentGraph = this.myPermanentGraph;
        if (permanentGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getPermanentGraph"));
        }
        return permanentGraph;
    }

    @NotNull
    public Map<Integer, GraphCommit> getCommitsWithNotLoadParentMap() {
        Map<Integer, GraphCommit> map = this.myCommitsWithNotLoadParentMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getCommitsWithNotLoadParentMap"));
        }
        return map;
    }

    @NotNull
    public PermanentGraphLayout getPermanentGraphLayout() {
        PermanentGraphLayout permanentGraphLayout = this.myPermanentGraphLayout;
        if (permanentGraphLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getPermanentGraphLayout"));
        }
        return permanentGraphLayout;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        ContainingBranchesGetter containingBranchesGetter = this.myContainingBranchesGetter;
        if (containingBranchesGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getContainingBranchesGetter"));
        }
        return containingBranchesGetter;
    }

    @NotNull
    public MutableGraph getMutableGraph() {
        MutableGraph mutableGraph = this.myMutableGraph;
        if (mutableGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getMutableGraph"));
        }
        return mutableGraph;
    }

    @NotNull
    public GraphRender getGraphRender() {
        GraphRender graphRender = this.myGraphRender;
        if (graphRender == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphData", "getGraphRender"));
        }
        return graphRender;
    }

    public int getCountVisibleNodes() {
        return this.getMutableGraph().getCountVisibleNodes();
    }

    public void assertRange(int visibleRowIndex) {
        if (visibleRowIndex < 0 || visibleRowIndex >= this.getCountVisibleNodes()) {
            throw new IllegalArgumentException("Row does not exist! Request row index: " + visibleRowIndex + ", count rows: " + this.getCountVisibleNodes());
        }
    }
}

