/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.facade;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.graph.ChangeCursorActionRequest;
import com.intellij.vcs.log.graph.ClickGraphAction;
import com.intellij.vcs.log.graph.GraphAction;
import com.intellij.vcs.log.graph.GraphActionRequest;
import com.intellij.vcs.log.graph.GraphAnswer;
import com.intellij.vcs.log.graph.GraphChange;
import com.intellij.vcs.log.graph.JumpToNotLoadCommitActionRequest;
import com.intellij.vcs.log.graph.JumpToRowActionRequest;
import com.intellij.vcs.log.graph.LinearBranchesExpansionAction;
import com.intellij.vcs.log.graph.LongEdgesAction;
import com.intellij.vcs.log.graph.MouseOverAction;
import com.intellij.vcs.log.graph.SelectAllRelativeCommitsAction;
import com.intellij.vcs.log.newgraph.facade.GraphData;
import com.intellij.vcs.log.newgraph.gpaph.Edge;
import com.intellij.vcs.log.newgraph.gpaph.GraphElement;
import com.intellij.vcs.log.newgraph.gpaph.actions.ClickInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.LinearBranchesExpansionInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.MouseOverArrowInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.MouseOverGraphElementInternalGraphAction;
import com.intellij.vcs.log.newgraph.gpaph.actions.SelectAllRelativeCommitsInternalGraphAction;
import com.intellij.vcs.log.newgraph.render.cell.GraphCell;
import com.intellij.vcs.log.newgraph.render.cell.SpecialRowElement;
import java.awt.Cursor;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphActionDispatcher {
    private static final Logger LOG = Logger.getInstance(GraphActionDispatcher.class);
    @NotNull
    private final GraphData myGraphData;

    public GraphActionDispatcher(@NotNull GraphData graphData) {
        if (graphData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "<init>"));
        }
        this.myGraphData = graphData;
    }

    @Nullable
    public GraphAnswer performAction(@NotNull GraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "performAction"));
        }
        if (action instanceof LongEdgesAction) {
            this.myGraphData.getGraphRender().setShowLongEdges(((LongEdgesAction)action).shouldShowLongEdges());
        }
        if (action instanceof MouseOverAction) {
            return this.mouseOverAction((MouseOverAction)action);
        }
        if (action instanceof ClickGraphAction) {
            return this.clickToGraph((ClickGraphAction)action);
        }
        if (action instanceof LinearBranchesExpansionAction) {
            this.myGraphData.getMutableGraph().performAction(new LinearBranchesExpansionInternalGraphAction(((LinearBranchesExpansionAction)action).shouldExpand()));
            this.myGraphData.getGraphRender().invalidate();
            return ActionRequestGraphAnswer.JUMP_TO_FIRST_ROW;
        }
        if (action instanceof SelectAllRelativeCommitsAction) {
            this.selectAllRelativeCommits((SelectAllRelativeCommitsAction)action);
        }
        return null;
    }

    private void selectAllRelativeCommits(@NotNull SelectAllRelativeCommitsAction action) {
        SelectAllRelativeCommitsInternalGraphAction internalGraphAction;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "selectAllRelativeCommits"));
        }
        if (action == SelectAllRelativeCommitsAction.DESELECT_ALL) {
            internalGraphAction = SelectAllRelativeCommitsInternalGraphAction.DESELECT_ALL;
        } else {
            int visibleRowIndex = action.getVisibleRowIndex();
            this.myGraphData.assertRange(visibleRowIndex);
            internalGraphAction = new SelectAllRelativeCommitsInternalGraphAction(visibleRowIndex);
        }
        this.myGraphData.getMutableGraph().performAction(internalGraphAction);
    }

    @Nullable
    private GraphAnswer clickToGraph(@NotNull ClickGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "clickToGraph"));
        }
        int visibleRowIndex = action.getRow();
        if (visibleRowIndex >= this.myGraphData.getMutableGraph().getCountVisibleNodes()) {
            return null;
        }
        Point clickPoint = action.getRelativePoint();
        if (clickPoint == null) {
            return null;
        }
        Pair<SpecialRowElement, GraphElement> arrowOrGraphElement = this.getOverArrowOrGraphElement(visibleRowIndex, clickPoint);
        if (arrowOrGraphElement.first != null) {
            Edge edge = (Edge)((SpecialRowElement)arrowOrGraphElement.first).getElement();
            int toRow = ((SpecialRowElement)arrowOrGraphElement.first).getType() == SpecialRowElement.Type.DOWN_ARROW ? edge.getDownNodeVisibleIndex() : edge.getUpNodeVisibleIndex();
            if (toRow == Integer.MAX_VALUE) {
                int indexOfParentCommit = this.myGraphData.getMutableGraph().getNode(edge.getUpNodeVisibleIndex()).getDownEdges().indexOf(edge);
                int indexInPermanentGraph = this.myGraphData.getMutableGraph().getIndexInPermanentGraph(edge.getUpNodeVisibleIndex());
                int commitHashIndex = this.myGraphData.getPermanentGraph().getHashIndex(indexInPermanentGraph);
                GraphCommit commit = this.myGraphData.getCommitsWithNotLoadParentMap().get(commitHashIndex);
                if (indexOfParentCommit >= 0 && indexOfParentCommit < commit.getParentIndices().length) {
                    return ActionRequestGraphAnswer.jumpToNotLoadCommit(commit.getParentIndices()[indexOfParentCommit]);
                }
                LOG.error("Jump to not load commit with bad edge index. Edge index: " + indexOfParentCommit + ", commit hash index: " + commitHashIndex + "count parents commits: " + commit.getParentIndices().length + ".");
                return null;
            }
            return ActionRequestGraphAnswer.jumpToRow(toRow);
        }
        int toRow = this.myGraphData.getMutableGraph().performAction(new ClickInternalGraphAction((GraphElement)arrowOrGraphElement.second));
        this.myGraphData.getMutableGraph().performAction(new MouseOverGraphElementInternalGraphAction(null));
        this.myGraphData.getGraphRender().invalidate();
        if (toRow != -1) {
            return ActionRequestGraphAnswer.jumpToRow(toRow);
        }
        return null;
    }

    @Nullable
    private GraphAnswer mouseOverAction(@NotNull MouseOverAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "mouseOverAction"));
        }
        int visibleRowIndex = action.getRow();
        if (visibleRowIndex >= this.myGraphData.getMutableGraph().getCountVisibleNodes()) {
            return null;
        }
        Pair<SpecialRowElement, GraphElement> arrowOrGraphElement = this.getOverArrowOrGraphElement(visibleRowIndex, action.getRelativePoint());
        if (arrowOrGraphElement.first != null) {
            this.myGraphData.getMutableGraph().performAction(new MouseOverGraphElementInternalGraphAction(null));
            this.myGraphData.getMutableGraph().performAction(new MouseOverArrowInternalGraphAction((SpecialRowElement)arrowOrGraphElement.first));
            return ActionRequestGraphAnswer.CHANGE_CURSOR_TO_HAND_CURSOR;
        }
        this.myGraphData.getMutableGraph().performAction(new MouseOverArrowInternalGraphAction(null));
        this.myGraphData.getMutableGraph().performAction(new MouseOverGraphElementInternalGraphAction((GraphElement)arrowOrGraphElement.second));
        return ActionRequestGraphAnswer.CHANGE_CURSOR_TO_DEFAULT;
    }

    @NotNull
    private Pair<SpecialRowElement, GraphElement> getOverArrowOrGraphElement(int visibleRowIndex, @NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "getOverArrowOrGraphElement"));
        }
        GraphCell graphCell = this.myGraphData.getGraphRender().getCellGenerator().getGraphCell(visibleRowIndex);
        SpecialRowElement overArrow = this.myGraphData.getGraphRender().getCellPainter().mouseOverArrow(graphCell, point.x, point.y);
        GraphElement overElement = this.myGraphData.getGraphRender().getCellPainter().mouseOver(graphCell, point.x, point.y);
        Pair pair = new Pair((Object)overArrow, (Object)overElement);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher", "getOverArrowOrGraphElement"));
        }
        return pair;
    }

    private static class ActionRequestGraphAnswer
    implements GraphAnswer {
        public static final GraphAnswer CHANGE_CURSOR_TO_HAND_CURSOR = ActionRequestGraphAnswer.changeCursor(Cursor.getPredefinedCursor(12));
        public static final GraphAnswer CHANGE_CURSOR_TO_DEFAULT = ActionRequestGraphAnswer.changeCursor(Cursor.getDefaultCursor());
        public static final GraphAnswer JUMP_TO_FIRST_ROW = ActionRequestGraphAnswer.jumpToRow(0);
        private static final GraphChange SOME_CHANGE = new GraphChange(){};
        @NotNull
        private final GraphActionRequest myGraphActionRequest;
        private final boolean mySomebodyChanged;

        @NotNull
        public static GraphAnswer jumpToRow(int rowIndex) {
            ActionRequestGraphAnswer actionRequestGraphAnswer = new ActionRequestGraphAnswer((GraphActionRequest)new JumpToRowActionRequest(rowIndex), true);
            if (actionRequestGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "jumpToRow"));
            }
            return actionRequestGraphAnswer;
        }

        @NotNull
        public static GraphAnswer jumpToNotLoadCommit(int commitHashIndex) {
            ActionRequestGraphAnswer actionRequestGraphAnswer = new ActionRequestGraphAnswer((GraphActionRequest)new JumpToNotLoadCommitActionRequest(commitHashIndex));
            if (actionRequestGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "jumpToNotLoadCommit"));
            }
            return actionRequestGraphAnswer;
        }

        @NotNull
        public static GraphAnswer changeCursor(@NotNull Cursor cursor) {
            if (cursor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "changeCursor"));
            }
            ActionRequestGraphAnswer actionRequestGraphAnswer = new ActionRequestGraphAnswer(new ChangeCursorActionRequest(cursor));
            if (actionRequestGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "changeCursor"));
            }
            return actionRequestGraphAnswer;
        }

        private ActionRequestGraphAnswer(@NotNull GraphActionRequest graphActionRequest) {
            if (graphActionRequest == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "<init>"));
            }
            this(graphActionRequest, false);
        }

        private ActionRequestGraphAnswer(@NotNull GraphActionRequest graphActionRequest, boolean somebodyChanged) {
            if (graphActionRequest == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/GraphActionDispatcher$ActionRequestGraphAnswer", "<init>"));
            }
            this.myGraphActionRequest = graphActionRequest;
            this.mySomebodyChanged = somebodyChanged;
        }

        @Nullable
        public GraphChange getGraphChange() {
            if (this.mySomebodyChanged) {
                return SOME_CHANGE;
            }
            return null;
        }

        @Nullable
        public GraphActionRequest getActionRequest() {
            return this.myGraphActionRequest;
        }
    }
}

