/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.facade;

import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.InvalidRequestException;
import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import com.intellij.vcs.log.newgraph.utils.Flags;
import com.intellij.vcs.log.newgraph.utils.MyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentBranches {
    private final PermanentGraph myPermanentGraph;
    private final Flags myVisibleNodesInBranches;
    private final DfsUtil myDfsUtil;

    public CurrentBranches(PermanentGraph permanentGraph, Flags visibleNodesInBranches, DfsUtil dfsUtil) {
        this.myPermanentGraph = permanentGraph;
        this.myVisibleNodesInBranches = visibleNodesInBranches;
        this.myDfsUtil = dfsUtil;
        this.setVisibleBranches(null);
    }

    public Flags getVisibleNodesInBranches() {
        return this.myVisibleNodesInBranches;
    }

    public void setVisibleBranches(@Nullable Set<Integer> heads) {
        if (heads == null) {
            MyUtils.setAllValues(this.myVisibleNodesInBranches, true);
            return;
        }
        MyUtils.setAllValues(this.myVisibleNodesInBranches, false);
        HashSet startedNodes = new HashSet();
        for (int i = 0; i < this.myPermanentGraph.nodesCount(); ++i) {
            if (!heads.contains(this.myPermanentGraph.getHashIndex(i))) continue;
            startedNodes.add(i);
        }
        if (startedNodes.size() != heads.size() || heads.isEmpty()) {
            throw new InvalidRequestException("Heads size is invalid! startedNodes " + startedNodes + "; heads: " + heads);
        }
        this.selectAllVisibleNodes((Set<Integer>)startedNodes);
    }

    private void selectAllVisibleNodes(@NotNull Set<Integer> startedNodes) {
        if (startedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/CurrentBranches", "selectAllVisibleNodes"));
        }
        for (int startNode : startedNodes) {
            this.myVisibleNodesInBranches.set(startNode, true);
            this.myDfsUtil.nodeDfsIterator(startNode, new DfsUtil.NextNode(){

                @Override
                public int fun(int currentNode) {
                    for (int downNode : CurrentBranches.this.myPermanentGraph.getDownNodes(currentNode)) {
                        if (downNode == Integer.MAX_VALUE || CurrentBranches.this.myVisibleNodesInBranches.get(downNode)) continue;
                        CurrentBranches.this.myVisibleNodesInBranches.set(downNode, true);
                        return downNode;
                    }
                    return -1;
                }
            });
        }
    }
}

