/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.newgraph.facade;

import com.intellij.vcs.log.newgraph.PermanentGraph;
import com.intellij.vcs.log.newgraph.utils.DfsUtil;
import com.intellij.vcs.log.newgraph.utils.Flags;
import com.intellij.vcs.log.newgraph.utils.MyUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ContainingBranchesGetter {
    @NotNull
    private final PermanentGraph myPermanentGraph;
    @NotNull
    private final Set<Integer> myBranchNodeIndexes;
    @NotNull
    private final DfsUtil myDfsUtil;
    @NotNull
    private final Flags myTempFlags;

    public ContainingBranchesGetter(@NotNull PermanentGraph permanentGraph, @NotNull Set<Integer> branchNodeIndexes, @NotNull DfsUtil dfsUtil, @NotNull Flags tempFlags) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/newgraph/facade/ContainingBranchesGetter", "<init>"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/newgraph/facade/ContainingBranchesGetter", "<init>"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/newgraph/facade/ContainingBranchesGetter", "<init>"));
        }
        if (tempFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/newgraph/facade/ContainingBranchesGetter", "<init>"));
        }
        this.myPermanentGraph = permanentGraph;
        this.myBranchNodeIndexes = branchNodeIndexes;
        this.myDfsUtil = dfsUtil;
        this.myTempFlags = tempFlags;
    }

    public Set<Integer> getBranchHashIndexes(int nodeIndex) {
        final HashSet<Integer> result = new HashSet<Integer>();
        MyUtils.setAllValues(this.myTempFlags, false);
        this.myTempFlags.set(nodeIndex, true);
        this.checkAndAdd(nodeIndex, result);
        this.myDfsUtil.nodeDfsIterator(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int upNode : ContainingBranchesGetter.this.myPermanentGraph.getUpNodes(currentNode)) {
                    if (ContainingBranchesGetter.this.myTempFlags.get(upNode)) continue;
                    ContainingBranchesGetter.this.myTempFlags.set(upNode, true);
                    ContainingBranchesGetter.this.checkAndAdd(upNode, result);
                    return upNode;
                }
                return -1;
            }
        });
        return result;
    }

    private void checkAndAdd(int nodeIndex, Set<Integer> result) {
        if (this.myBranchNodeIndexes.contains(nodeIndex)) {
            result.add(this.myPermanentGraph.getHashIndex(nodeIndex));
        }
    }
}

