/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.graph.GraphFacade;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class VcsLogUtil {
    @NotNull
    public static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        MultiMap<VirtualFile, VcsRef> map = new MultiMap<VirtualFile, VcsRef>(){

            protected Map<VirtualFile, Collection<VcsRef>> createMap() {
                return new TreeMap<VirtualFile, Collection<VcsRef>>(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile o1, VirtualFile o2) {
                        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
                    }
                });
            }
        };
        for (VcsRef ref : refs) {
            map.putValue((Object)ref.getRoot(), (Object)ref);
        }
        MultiMap<VirtualFile, VcsRef> multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull GraphFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return facade.getCommitAtRow(index);
            }

            @Override
            public int size() {
                return facade.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        return abstractList;
    }
}

