/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.TimedVcsCommitImpl;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsCommitImpl;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.impl.VcsShortCommitDetailsImpl;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsLogObjectsFactoryImpl
implements VcsLogObjectsFactory {
    private static final Logger LOG = Logger.getInstance(VcsLogObjectsFactoryImpl.class);
    @NotNull
    private final VcsLogManager myLogManager;

    public VcsLogObjectsFactoryImpl(@NotNull VcsLogManager logManager) {
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "<init>"));
        }
        this.myLogManager = logManager;
    }

    @NotNull
    public Hash createHash(@NotNull String stringHash) {
        if (stringHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createHash"));
        }
        Hash hash = HashImpl.build(stringHash);
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createHash"));
        }
        return hash;
    }

    @NotNull
    public VcsCommit createCommit(@NotNull Hash hash, @NotNull List<Hash> parents) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommit"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommit"));
        }
        VcsCommitImpl vcsCommitImpl = new VcsCommitImpl(hash, parents);
        if (vcsCommitImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommit"));
        }
        return vcsCommitImpl;
    }

    @NotNull
    public TimedVcsCommit createTimedCommit(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        TimedVcsCommitImpl timedVcsCommitImpl = new TimedVcsCommitImpl(hash, parents, timeStamp);
        if (timedVcsCommitImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        return timedVcsCommitImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsShortCommitDetails createShortDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, String string) {
        void authorEmail;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        VcsUser author = this.createUser(authorName, (String)authorEmail);
        VcsShortCommitDetailsImpl vcsShortCommitDetailsImpl = new VcsShortCommitDetailsImpl(hash, parents, timeStamp, root, subject, author);
        if (vcsShortCommitDetailsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        return vcsShortCommitDetailsImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsCommitMetadata createCommitMetadata(@NotNull Hash hash, @NotNull List<Hash> parents, long time, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message, @NotNull String committerName, @NotNull String committerEmail, long l) {
        void authorTime;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (authorEmail == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (committerEmail == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "9", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        VcsCommitMetadataImpl vcsCommitMetadataImpl = new VcsCommitMetadataImpl(hash, parents, time, root, subject, author, message, committer, (long)authorTime);
        if (vcsCommitMetadataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        return vcsCommitMetadataImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsFullCommitDetails createFullDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long time, VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message, @NotNull String committerName, @NotNull String committerEmail, long authorTime, @NotNull ThrowableComputable<Collection<Change>, ? extends Exception> throwableComputable) {
        void changesGetter;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (authorEmail == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (committerEmail == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "9", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (throwableComputable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "11", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        VcsChangesLazilyParsedDetails vcsChangesLazilyParsedDetails = new VcsChangesLazilyParsedDetails(hash, parents, time, root, subject, author, message, committer, authorTime, (ThrowableComputable<Collection<Change>, ? extends Exception>)changesGetter);
        if (vcsChangesLazilyParsedDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        return vcsChangesLazilyParsedDetails;
    }

    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        VcsLogDataHolder dataHolder = this.myLogManager.getDataHolder();
        if (dataHolder == null) {
            VcsUserImpl vcsUserImpl = new VcsUserImpl(name, email);
            if (vcsUserImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
            }
            return vcsUserImpl;
        }
        VcsUser vcsUser = dataHolder.getUserRegistry().createUser(name, email);
        if (vcsUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        return vcsUser;
    }

    @NotNull
    public VcsRef createRef(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        VcsRefImpl vcsRefImpl = new VcsRefImpl(new NotNullFunction<Hash, Integer>(){

            @NotNull
            public Integer fun(Hash hash) {
                VcsLogDataHolder dataHolder = VcsLogObjectsFactoryImpl.this.myLogManager.getDataHolder();
                if (dataHolder == null) {
                    LOG.error("The log data holder should have been initialized at this point");
                    Integer n = -1;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl$1", "fun"));
                    }
                    return n;
                }
                Integer n = dataHolder.getCommitIndex(hash);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl$1", "fun"));
                }
                return n;
            }
        }, commitHash, name, type, root);
        if (vcsRefImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        return vcsRefImpl;
    }
}

