/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsLogSettings mySettings;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    private PostponeableLogRefresher myLogRefresher;
    private volatile VcsLogDataHolder myLogDataHolder;
    private volatile VcsLogUiImpl myUi;

    public VcsLogManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.mySettings = settings;
        this.myUiProperties = uiProperties;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    @NotNull
    public JComponent initContent() {
        final Map<VirtualFile, VcsLogProvider> logProviders = this.findLogProviders();
        final VcsLogContainer mainPanel = new VcsLogContainer((Disposable)this.myProject);
        this.myLogDataHolder = new VcsLogDataHolder(this.myProject, this, logProviders, this.mySettings);
        this.myLogDataHolder.initialize(new PairConsumer<VcsLogDataHolder, DataPack>(){

            public void consume(VcsLogDataHolder vcsLogDataHolder, DataPack dataPack) {
                VcsLogUiImpl logUI = new VcsLogUiImpl(vcsLogDataHolder, VcsLogManager.this.myProject, VcsLogManager.this.mySettings, new VcsLogColorManagerImpl(logProviders.keySet()), VcsLogManager.this.myUiProperties, dataPack);
                VcsLogManager.this.myLogDataHolder = vcsLogDataHolder;
                VcsLogManager.this.myUi = logUI;
                mainPanel.init(logUI.getMainFrame().getMainComponent());
                final VcsLogGraphTable graphTable = logUI.getTable();
                if (graphTable.getRowCount() > 0) {
                    IdeFocusManager.getInstance((Project)VcsLogManager.this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(new Runnable(){

                        @Override
                        public void run() {
                            graphTable.setRowSelectionInterval(0, 0);
                        }
                    });
                }
                VcsLogManager.this.myLogRefresher = new PostponeableLogRefresher(VcsLogManager.this.myProject, vcsLogDataHolder);
                VcsLogManager.this.refreshLogOnVcsEvents(logProviders);
            }
        });
        VcsLogContainer vcsLogContainer = mainPanel;
        if (vcsLogContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "initContent"));
        }
        return vcsLogContainer;
    }

    private void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager", "refreshLogOnVcsEvents"));
        }
        MultiMap providers2roots = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            providers2roots.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : providers2roots.entrySet()) {
            ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), (VcsLogRefresher)this.myLogRefresher);
        }
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> findLogProviders() {
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions(LOG_PROVIDER_EP, (AreaInstance)this.myProject);
        block0: for (AbstractVcs vcs : this.myVcsManager.getAllActiveVcss()) {
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                for (VirtualFile root : this.myVcsManager.getRootsUnderVcs(vcs)) {
                    logProviders.put(root, provider);
                }
                continue block0;
            }
        }
        HashMap hashMap = logProviders;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        return hashMap;
    }

    @Nullable
    public VcsLogDataHolder getDataHolder() {
        return this.myLogDataHolder;
    }

    @Nullable
    public VcsLogUiImpl getLogUi() {
        return this.myUi;
    }

    public void dispose() {
    }

    private static class PostponeableLogRefresher
    implements VcsLogRefresher,
    Disposable {
        private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
        @NotNull
        private final VcsLogDataHolder myDataHolder;
        @NotNull
        private final ToolWindowManagerImpl myToolWindowManager;
        @NotNull
        private final ToolWindowImpl myToolWindow;
        @NotNull
        private final MyRefreshPostponedEventsListener myPostponedEventsListener;
        @NotNull
        private final Set<VirtualFile> myRootsToRefreshRefs;
        @NotNull
        private final Set<VirtualFile> myRootsToRefresh;
        @NotNull
        private final Object REFRESH_LOCK;

        public PostponeableLogRefresher(@NotNull Project project, @NotNull VcsLogDataHolder dataHolder) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "<init>"));
            }
            if (dataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "<init>"));
            }
            this.myRootsToRefreshRefs = ContainerUtil.newHashSet();
            this.myRootsToRefresh = ContainerUtil.newHashSet();
            this.REFRESH_LOCK = new Object();
            this.myDataHolder = dataHolder;
            this.myToolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
            this.myToolWindow = (ToolWindowImpl)this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
            Disposer.register((Disposable)this.myToolWindow.getContentManager(), (Disposable)this);
            this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.addToolWindowManagerListener(this.myPostponedEventsListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "refresh"));
            }
            if (this.isOurContentPaneShowing()) {
                this.myDataHolder.refresh(root);
            } else {
                Object object = this.REFRESH_LOCK;
                synchronized (object) {
                    this.myRootsToRefresh.add(root);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshRefs(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "refreshRefs"));
            }
            if (this.isOurContentPaneShowing()) {
                this.myDataHolder.refreshRefs(root);
            } else {
                Object object = this.REFRESH_LOCK;
                synchronized (object) {
                    this.myRootsToRefreshRefs.add(root);
                }
            }
        }

        public void dispose() {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.removeToolWindowManagerListener(this.myPostponedEventsListener);
        }

        private boolean isOurContentPaneShowing() {
            if (this.myToolWindowManager.isToolWindowRegistered(TOOLWINDOW_ID) && this.myToolWindow.isVisible()) {
                Content content = this.myToolWindow.getContentManager().getSelectedContent();
                return content != null && content.getTabName().equals("Log");
            }
            return false;
        }

        private void refreshPostponedRoots() {
            for (VirtualFile root : this.safeGetAndClear(this.myRootsToRefresh)) {
                this.myDataHolder.refresh(root);
            }
            for (VirtualFile root : this.safeGetAndClear(this.myRootsToRefreshRefs)) {
                this.myDataHolder.refreshRefs(root);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private Set<VirtualFile> safeGetAndClear(@NotNull Set<VirtualFile> unsafeRefs) {
            if (unsafeRefs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "safeGetAndClear"));
            }
            HashSet safeRefs = ContainerUtil.newHashSet();
            Object object = this.REFRESH_LOCK;
            synchronized (object) {
                safeRefs.addAll(unsafeRefs);
                unsafeRefs.clear();
            }
            HashSet hashSet = safeRefs;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "safeGetAndClear"));
            }
            return hashSet;
        }

        private class MyRefreshPostponedEventsListener
        extends ContentManagerAdapter
        implements ToolWindowManagerListener {
            private MyRefreshPostponedEventsListener() {
            }

            public void selectionChanged(ContentManagerEvent event) {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void stateChanged() {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher$MyRefreshPostponedEventsListener", "toolWindowRegistered"));
                }
            }

            private void refreshRootsIfNeeded() {
                if (PostponeableLogRefresher.this.isOurContentPaneShowing()) {
                    PostponeableLogRefresher.this.refreshPostponedRoots();
                }
            }
        }
    }

    private class VcsLogContainer
    extends JPanel
    implements TypeSafeDataProvider {
        private final JBLoadingPanel myLoadingPanel;

        VcsLogContainer(Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$VcsLogContainer", "<init>"));
            }
            this.setLayout(new BorderLayout());
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable);
            this.add((Component)this.myLoadingPanel);
            this.myLoadingPanel.startLoading();
        }

        void init(@NotNull JComponent mainComponent) {
            if (mainComponent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsLogManager$VcsLogContainer", "init"));
            }
            this.myLoadingPanel.add((Component)mainComponent);
            this.myLoadingPanel.stopLoading();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (VcsLogManager.this.myUi != null) {
                VcsLogManager.this.myUi.getMainFrame().calcData(key, sink);
            }
        }
    }
}

