/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsCommitImpl
implements VcsCommit {
    @NotNull
    private final Hash myHash;
    @NotNull
    private final List<Hash> myParents;

    public VcsCommitImpl(@NotNull Hash hash, @NotNull List<Hash> parents) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/impl/VcsCommitImpl", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/impl/VcsCommitImpl", "<init>"));
        }
        this.myHash = hash;
        this.myParents = new ArrayList<Hash>(parents);
    }

    @NotNull
    public final Hash getHash() {
        Hash hash = this.myHash;
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsCommitImpl", "getHash"));
        }
        return hash;
    }

    @NotNull
    public final List<Hash> getParents() {
        List<Hash> list = this.myParents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsCommitImpl", "getParents"));
        }
        return list;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VcsCommitImpl)) {
            return false;
        }
        return this.myHash.equals(((VcsCommitImpl)obj).myHash);
    }

    public final int hashCode() {
        return this.myHash.hashCode();
    }

    public String toString() {
        return this.myHash.toShortString() + "|-" + StringUtil.join((Collection)ContainerUtil.map(this.myParents, (Function)new Function<Hash, String>(){

            public String fun(Hash hash) {
                return hash.toShortString();
            }
        }), (String)",");
    }
}

