/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.fragment;

import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.fragment.elements.HideFragmentEdge;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphFragmentController
implements FragmentManager.GraphPreDecorator {
    private final Set<Node> hideNodes = new HashSet<Node>();
    private final Map<Edge, GraphFragment> hideFragments = new HashMap<Edge, GraphFragment>();
    private final MultiMap<Node, Edge> upNodeEdges = new MultiMap();
    private final MultiMap<Node, Edge> downNodeEdges = new MultiMap();

    @Override
    public boolean isVisibleNode(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "isVisibleNode"));
        }
        return !this.hideNodes.contains(node);
    }

    @Override
    @Nullable
    public Edge getHideFragmentUpEdge(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "getHideFragmentUpEdge"));
        }
        Collection edges = this.downNodeEdges.get((Object)node);
        for (Edge edge : edges) {
            if (!this.isVisibleNode(edge.getUpNode())) continue;
            return edge;
        }
        return null;
    }

    @Override
    @Nullable
    public Edge getHideFragmentDownEdge(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "getHideFragmentDownEdge"));
        }
        Collection edges = this.upNodeEdges.get((Object)node);
        for (Edge edge : edges) {
            if (!this.isVisibleNode(edge.getDownNode())) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    private Edge getHideFragmentEdge(@NotNull GraphFragment fragment) {
        Edge edge;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "getHideFragmentEdge"));
        }
        if (!fragment.getIntermediateNodes().isEmpty()) {
            throw new IllegalArgumentException("is not hide fragment: " + fragment);
        }
        List<Edge> downEdges = fragment.getUpNode().getDownEdges();
        if (downEdges.size() == 1 && (edge = downEdges.get(0)).getType() == Edge.EdgeType.HIDE_FRAGMENT && edge.getDownNode() == fragment.getDownNode()) {
            Edge edge2 = edge;
            if (edge2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "getHideFragmentEdge"));
            }
            return edge2;
        }
        throw new IllegalArgumentException("is bad hide fragment: " + fragment);
    }

    public void show(@NotNull GraphFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "show"));
        }
        Edge hideFragmentEdge = this.getHideFragmentEdge(fragment);
        this.upNodeEdges.remove((Object)hideFragmentEdge.getUpNode(), (Object)hideFragmentEdge);
        this.downNodeEdges.remove((Object)hideFragmentEdge.getDownNode(), (Object)hideFragmentEdge);
        GraphFragment hideFragment = this.hideFragments.remove(hideFragmentEdge);
        this.hideNodes.removeAll(hideFragment.getIntermediateNodes());
    }

    public void hide(@NotNull GraphFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/GraphFragmentController", "hide"));
        }
        HideFragmentEdge edge = new HideFragmentEdge(fragment.getUpNode(), fragment.getDownNode());
        this.upNodeEdges.putValue((Object)edge.getUpNode(), (Object)edge);
        this.downNodeEdges.putValue((Object)edge.getDownNode(), (Object)edge);
        this.hideNodes.addAll(fragment.getIntermediateNodes());
        this.hideFragments.put(edge, fragment);
    }

    public void showAll() {
        this.hideNodes.clear();
        this.hideFragments.clear();
        this.upNodeEdges.clear();
        this.downNodeEdges.clear();
    }
}

