/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.fragment;

import com.intellij.util.Function;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.GraphElement;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graphmodel.FragmentManager;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.fragment.FragmentGenerator;
import com.intellij.vcs.log.graphmodel.fragment.GraphFragmentController;
import com.intellij.vcs.log.graphmodel.fragment.elements.SimpleGraphFragment;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentManagerImpl
implements FragmentManager {
    private final MutableGraph graph;
    private final FragmentGenerator fragmentGenerator;
    private final GraphFragmentController graphDecorator = new GraphFragmentController();
    private final CallBackFunction callBackFunction;
    private boolean updateFlag = true;

    public FragmentManagerImpl(MutableGraph graph, CallBackFunction callBackFunction) {
        this.graph = graph;
        this.callBackFunction = callBackFunction;
        this.fragmentGenerator = new FragmentGenerator(graph);
    }

    @Override
    public void setUnconcealedNodeFunction(@NotNull Function<Node, Boolean> isUnconcealedNode) {
        if (isUnconcealedNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "setUnconcealedNodeFunction"));
        }
        this.fragmentGenerator.setUnconcealedNodeFunction(isUnconcealedNode);
    }

    @Override
    @NotNull
    public FragmentManager.GraphPreDecorator getGraphPreDecorator() {
        GraphFragmentController graphFragmentController = this.graphDecorator;
        if (graphFragmentController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "getGraphPreDecorator"));
        }
        return graphFragmentController;
    }

    @Nullable
    private Edge getHideEdge(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "getHideEdge"));
        }
        for (Edge edge : node.getDownEdges()) {
            if (edge.getType() != Edge.EdgeType.HIDE_FRAGMENT) continue;
            return edge;
        }
        for (Edge edge : node.getUpEdges()) {
            if (edge.getType() != Edge.EdgeType.HIDE_FRAGMENT) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    private Node getUpNode(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "getUpNode"));
        }
        Node node = graphElement.getNode();
        if (node == null) {
            node = graphElement.getEdge().getUpNode();
        }
        Node node2 = node;
        if (node2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "getUpNode"));
        }
        return node2;
    }

    @Override
    @NotNull
    public Set<Node> allCommitsCurrentBranch(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "allCommitsCurrentBranch"));
        }
        Set<Node> set = this.fragmentGenerator.allCommitsCurrentBranch(this.getUpNode(graphElement));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "allCommitsCurrentBranch"));
        }
        return set;
    }

    @Override
    public Set<Node> getUpNodes(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "getUpNodes"));
        }
        return this.fragmentGenerator.getUpNodes(this.getUpNode(graphElement));
    }

    @Override
    @Nullable
    public GraphFragment relateFragment(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "relateFragment"));
        }
        Node node = graphElement.getNode();
        if (node != null) {
            Edge edge = this.getHideEdge(node);
            if (edge != null) {
                return new SimpleGraphFragment(edge.getUpNode(), edge.getDownNode(), Collections.<Node>emptySet());
            }
            GraphFragment fragment = this.fragmentGenerator.getFragment(node);
            if (fragment != null && fragment.getDownNode().getRowIndex() >= node.getRowIndex()) {
                return fragment;
            }
            return null;
        }
        Edge edge = graphElement.getEdge();
        assert (edge != null) : "bad graphElement: edge & node is null";
        if (edge.getType() == Edge.EdgeType.HIDE_FRAGMENT) {
            return new SimpleGraphFragment(edge.getUpNode(), edge.getDownNode(), Collections.<Node>emptySet());
        }
        GraphFragment fragment = this.fragmentGenerator.getFragment(edge.getUpNode());
        if (fragment != null && fragment.getDownNode().getRowIndex() >= edge.getDownNode().getRowIndex()) {
            return fragment;
        }
        return null;
    }

    @Override
    @NotNull
    public UpdateRequest changeVisibility(@NotNull GraphFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "changeVisibility"));
        }
        if (fragment.getIntermediateNodes().isEmpty()) {
            UpdateRequest updateRequest = this.show(fragment);
            if (updateRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "changeVisibility"));
            }
            return updateRequest;
        }
        UpdateRequest updateRequest = this.hide(fragment);
        if (updateRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "changeVisibility"));
        }
        return updateRequest;
    }

    @NotNull
    public UpdateRequest show(@NotNull GraphFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "show"));
        }
        this.graphDecorator.show(fragment);
        if (this.updateFlag) {
            UpdateRequest updateRequest = this.callBackFunction.runIntermediateUpdate(fragment.getUpNode(), fragment.getDownNode());
            if (updateRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "show"));
            }
            return updateRequest;
        }
        UpdateRequest updateRequest = UpdateRequest.ID_UpdateRequest;
        if (updateRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "show"));
        }
        return updateRequest;
    }

    @NotNull
    public UpdateRequest hide(@NotNull GraphFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "hide"));
        }
        this.graphDecorator.hide(fragment);
        if (this.updateFlag) {
            UpdateRequest updateRequest = this.callBackFunction.runIntermediateUpdate(fragment.getUpNode(), fragment.getDownNode());
            if (updateRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "hide"));
            }
            return updateRequest;
        }
        UpdateRequest updateRequest = UpdateRequest.ID_UpdateRequest;
        if (updateRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentManagerImpl", "hide"));
        }
        return updateRequest;
    }

    @Nullable
    private Node commitNodeInRow(int rowIndex) {
        for (Node node : this.graph.getNodeRows().get(rowIndex).getNodes()) {
            if (node.getType() != Node.NodeType.COMMIT_NODE) continue;
            return node;
        }
        return null;
    }

    @Override
    public void hideAll() {
        this.updateFlag = false;
        for (int rowIndex = 0; rowIndex < this.graph.getNodeRows().size(); ++rowIndex) {
            GraphFragment fragment;
            Node node = this.commitNodeInRow(rowIndex);
            if (node == null || (fragment = this.fragmentGenerator.getMaximumDownFragment(node)) == null) continue;
            this.hide(fragment);
        }
        this.updateFlag = true;
        this.callBackFunction.fullUpdate();
    }

    @Override
    public void showAll() {
        this.graphDecorator.showAll();
        this.callBackFunction.fullUpdate();
    }

    public static interface CallBackFunction {
        public UpdateRequest runIntermediateUpdate(@NotNull Node var1, @NotNull Node var2);

        public void fullUpdate();
    }
}

