/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graphmodel.fragment;

import com.intellij.util.Function;
import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graphmodel.GraphFragment;
import com.intellij.vcs.log.graphmodel.fragment.ShortFragmentGenerator;
import com.intellij.vcs.log.graphmodel.fragment.elements.SimpleGraphFragment;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    private static final int SEARCH_LIMIT = 20;
    private final ShortFragmentGenerator shortFragmentGenerator;
    private Function<Node, Boolean> isUnhiddenNodes = new Function<Node, Boolean>(){

        @NotNull
        public Boolean fun(@NotNull Node key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator$1", "fun"));
            }
            Boolean bl = false;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator$1", "fun"));
            }
            return bl;
        }
    };

    public FragmentGenerator(Graph graph) {
        this.shortFragmentGenerator = new ShortFragmentGenerator(graph);
    }

    public void setUnconcealedNodeFunction(Function<Node, Boolean> isUnconcealedNode) {
        this.shortFragmentGenerator.setUnconcealedNodeFunction(isUnconcealedNode);
        this.isUnhiddenNodes = isUnconcealedNode;
    }

    @NotNull
    public Set<Node> allCommitsCurrentBranch(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "allCommitsCurrentBranch"));
        }
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Node> downNodes = new HashSet<Node>();
        downNodes.add(node);
        while (!downNodes.isEmpty()) {
            Iterator iteratorNode = downNodes.iterator();
            Node nextNode = (Node)iteratorNode.next();
            iteratorNode.remove();
            if (!nodes.add(nextNode)) continue;
            for (Edge edge : nextNode.getDownEdges()) {
                downNodes.add(edge.getDownNode());
            }
        }
        HashSet<Node> upNodes = new HashSet<Node>();
        upNodes.add(node);
        nodes.remove(node);
        while (!upNodes.isEmpty()) {
            Iterator nodeIterator = upNodes.iterator();
            Node nextNode = (Node)nodeIterator.next();
            nodeIterator.remove();
            if (!nodes.add(nextNode)) continue;
            for (Edge edge : nextNode.getUpEdges()) {
                upNodes.add(edge.getUpNode());
            }
        }
        HashSet<Node> hashSet = nodes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "allCommitsCurrentBranch"));
        }
        return hashSet;
    }

    @NotNull
    public Set<Node> getUpNodes(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "getUpNodes"));
        }
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Node> upNodes = new HashSet<Node>();
        upNodes.add(node);
        while (!upNodes.isEmpty()) {
            Iterator nodeIterator = upNodes.iterator();
            Node nextNode = (Node)nodeIterator.next();
            nodeIterator.remove();
            if (!nodes.add(nextNode)) continue;
            for (Edge edge : nextNode.getUpEdges()) {
                upNodes.add(edge.getUpNode());
            }
        }
        HashSet<Node> hashSet = nodes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "getUpNodes"));
        }
        return hashSet;
    }

    public GraphFragment getFragment(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "getFragment"));
        }
        GraphFragment downFragment = null;
        for (int countTry = 20; countTry > 0 && (downFragment = this.getMaximumDownFragment(node)) == null; --countTry) {
            if (node.getUpEdges().isEmpty()) {
                return null;
            }
            node = node.getUpEdges().get(0).getUpNode();
        }
        if (downFragment == null) {
            return null;
        }
        GraphFragment upFragment = this.getMaximumUpFragment(node);
        if (upFragment == null) {
            return downFragment;
        }
        HashSet<Node> intermediateNodes = new HashSet<Node>(downFragment.getIntermediateNodes());
        intermediateNodes.addAll(upFragment.getIntermediateNodes());
        intermediateNodes.add(node);
        return new SimpleGraphFragment(upFragment.getUpNode(), downFragment.getDownNode(), intermediateNodes);
    }

    @Nullable
    public GraphFragment getMaximumDownFragment(@NotNull Node startNode) {
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "getMaximumDownFragment"));
        }
        if (startNode.getType() != Node.NodeType.COMMIT_NODE) {
            return null;
        }
        GraphFragment fragment = this.shortFragmentGenerator.getDownShortFragment(startNode);
        if (fragment == null) {
            return null;
        }
        HashSet<Node> intermediateNodes = new HashSet<Node>(fragment.getIntermediateNodes());
        Node endNode = fragment.getDownNode();
        while ((fragment = this.shortFragmentGenerator.getDownShortFragment(endNode)) != null && !((Boolean)this.isUnhiddenNodes.fun((Object)endNode)).booleanValue()) {
            intermediateNodes.addAll(fragment.getIntermediateNodes());
            intermediateNodes.add(endNode);
            endNode = fragment.getDownNode();
        }
        if (intermediateNodes.isEmpty()) {
            return null;
        }
        return new SimpleGraphFragment(startNode, endNode, intermediateNodes);
    }

    @Nullable
    public GraphFragment getMaximumUpFragment(@NotNull Node startNode) {
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graphmodel/fragment/FragmentGenerator", "getMaximumUpFragment"));
        }
        GraphFragment fragment = this.shortFragmentGenerator.getUpShortFragment(startNode);
        if (fragment == null) {
            return null;
        }
        HashSet<Node> intermediateNodes = new HashSet<Node>(fragment.getIntermediateNodes());
        Node endNode = fragment.getDownNode();
        while ((fragment = this.shortFragmentGenerator.getUpShortFragment(endNode)) != null && !((Boolean)this.isUnhiddenNodes.fun((Object)endNode)).booleanValue()) {
            intermediateNodes.addAll(fragment.getIntermediateNodes());
            intermediateNodes.add(endNode);
            endNode = fragment.getUpNode();
        }
        if (intermediateNodes.isEmpty()) {
            return null;
        }
        return new SimpleGraphFragment(endNode, startNode, intermediateNodes);
    }
}

