/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.mutable.elements;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.graph.mutable.GraphDecorator;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graph.mutable.elements.MutableNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MutableNodeRow
implements NodeRow {
    private final List<MutableNode> nodes;
    private final MutableGraph graph;
    private int rowIndex;

    public MutableNodeRow(@NotNull MutableGraph graph, int rowIndex) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/elements/MutableNodeRow", "<init>"));
        }
        this.nodes = new SmartList();
        this.graph = graph;
        this.rowIndex = rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @NotNull
    public GraphDecorator getGraphDecorator() {
        GraphDecorator graphDecorator = this.graph.getGraphDecorator();
        if (graphDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNodeRow", "getGraphDecorator"));
        }
        return graphDecorator;
    }

    @NotNull
    public List<MutableNode> getInnerNodeList() {
        List<MutableNode> list = this.nodes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNodeRow", "getInnerNodeList"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Node> getNodes() {
        ArrayList<Node> visibleNodes = new ArrayList<Node>(this.nodes.size());
        for (MutableNode node : this.nodes) {
            if (!this.getGraphDecorator().isVisibleNode(node)) continue;
            visibleNodes.add(node);
        }
        ArrayList<Node> arrayList = visibleNodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNodeRow", "getNodes"));
        }
        return arrayList;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    public String toString() {
        return this.getNodes().toString();
    }
}

