/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.mutable.elements;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.elements.Branch;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.elements.MutableNodeRow;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MutableNode
implements Node {
    private final Branch branch;
    private final int hash;
    private MutableNodeRow nodeRow = null;
    private Node.NodeType type;
    private final List<Edge> upEdges = new SmartList();
    private final List<Edge> downEdges = new SmartList();

    public MutableNode(Branch branch, int hash) {
        this.branch = branch;
        this.hash = hash;
    }

    @NotNull
    public List<Edge> getInnerUpEdges() {
        List<Edge> list = this.upEdges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getInnerUpEdges"));
        }
        return list;
    }

    @NotNull
    public List<Edge> getInnerDownEdges() {
        List<Edge> list = this.downEdges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getInnerDownEdges"));
        }
        return list;
    }

    @Override
    public int getRowIndex() {
        return this.nodeRow.getRowIndex();
    }

    public void setNodeRow(MutableNodeRow nodeRow) {
        this.nodeRow = nodeRow;
    }

    public void setType(Node.NodeType type) {
        this.type = type;
    }

    @Override
    @NotNull
    public Node.NodeType getType() {
        Node.NodeType nodeType = this.type;
        if (nodeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getType"));
        }
        return nodeType;
    }

    @Override
    @NotNull
    public List<Edge> getUpEdges() {
        List<Edge> list = this.nodeRow.getGraphDecorator().getUpEdges(this, this.upEdges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getUpEdges"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Edge> getDownEdges() {
        List<Edge> list = this.nodeRow.getGraphDecorator().getDownEdges(this, this.downEdges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getDownEdges"));
        }
        return list;
    }

    @Override
    public int getCommitIndex() {
        return this.hash;
    }

    @Override
    @NotNull
    public Branch getBranch() {
        Branch branch = this.branch;
        if (branch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/elements/MutableNode", "getBranch"));
        }
        return branch;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public Edge getEdge() {
        return null;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getCommitIndex();
    }
}

