/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.mutable;

import com.intellij.vcs.log.graph.Graph;
import com.intellij.vcs.log.graph.elements.Edge;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.elements.NodeRow;
import com.intellij.vcs.log.graph.mutable.GraphDecorator;
import com.intellij.vcs.log.graph.mutable.elements.MutableNodeRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableGraph
implements Graph {
    public static final GraphDecorator ID_DECORATOR = new GraphDecorator(){

        @Override
        public boolean isVisibleNode(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "isVisibleNode"));
            }
            return true;
        }

        @Override
        @NotNull
        public List<Edge> getDownEdges(@NotNull Node node, @NotNull List<Edge> innerDownEdges) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getDownEdges"));
            }
            if (innerDownEdges == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getDownEdges"));
            }
            List<Edge> list = innerDownEdges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getDownEdges"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<Edge> getUpEdges(@NotNull Node node, @NotNull List<Edge> innerUpEdges) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getUpEdges"));
            }
            if (innerUpEdges == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getUpEdges"));
            }
            List<Edge> list = innerUpEdges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/MutableGraph$1", "getUpEdges"));
            }
            return list;
        }
    };
    private final List<MutableNodeRow> allRows = new ArrayList<MutableNodeRow>();
    private final List<MutableNodeRow> visibleRows = new ArrayList<MutableNodeRow>();
    private GraphDecorator graphDecorator = ID_DECORATOR;

    public GraphDecorator getGraphDecorator() {
        return this.graphDecorator;
    }

    public void setGraphDecorator(GraphDecorator graphDecorator) {
        this.graphDecorator = graphDecorator;
    }

    @Override
    @NotNull
    public List<NodeRow> getNodeRows() {
        List<NodeRow> list = Collections.unmodifiableList(this.visibleRows);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/MutableGraph", "getNodeRows"));
        }
        return list;
    }

    @Override
    @Nullable
    public Node getCommitNodeInRow(int rowIndex) {
        if (rowIndex >= this.visibleRows.size()) {
            return null;
        }
        NodeRow nodeRow = this.visibleRows.get(rowIndex);
        for (Node node : nodeRow.getNodes()) {
            if (node.getType() != Node.NodeType.COMMIT_NODE && node.getType() != Node.NodeType.END_COMMIT_NODE) continue;
            return node;
        }
        return null;
    }

    public List<MutableNodeRow> getAllRows() {
        return this.allRows;
    }

    public void updateVisibleRows() {
        this.visibleRows.clear();
        for (MutableNodeRow row : this.allRows) {
            if (row.getNodes().isEmpty()) continue;
            row.setRowIndex(this.visibleRows.size());
            this.visibleRows.add(row);
        }
    }
}

