/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.mutable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.graph.elements.Branch;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graph.mutable.elements.MutableNode;
import com.intellij.vcs.log.graph.mutable.elements.MutableNodeRow;
import com.intellij.vcs.log.graph.mutable.elements.UsualEdge;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphBuilder {
    private static final Logger LOG = Logger.getInstance(GraphBuilder.class);
    private final MutableGraph graph;
    private final Map<Integer, MutableNode> underdoneNodes;
    private MultiMap<Integer, VcsRef> myRefsOfHashes;
    private MutableNodeRow nextRow;

    @NotNull
    public static MutableGraph build(@NotNull List<? extends GraphCommit> commitParentses, Collection<VcsRef> allRefs) {
        if (commitParentses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "build"));
        }
        GraphBuilder builder = new GraphBuilder(allRefs);
        MutableGraph mutableGraph = builder.runBuild(commitParentses);
        if (mutableGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "build"));
        }
        return mutableGraph;
    }

    static void createUsualEdge(@NotNull MutableNode up, @NotNull MutableNode down, @NotNull Branch branch) {
        if (up == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "createUsualEdge"));
        }
        if (down == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "createUsualEdge"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "createUsualEdge"));
        }
        UsualEdge edge = new UsualEdge(up, down, branch);
        up.getInnerDownEdges().add(edge);
        down.getInnerUpEdges().add(edge);
    }

    public GraphBuilder(MutableGraph graph, Map<Integer, MutableNode> underdoneNodes, MutableNodeRow nextRow, Collection<VcsRef> refs) {
        this.graph = graph;
        this.underdoneNodes = underdoneNodes;
        this.nextRow = nextRow;
        this.myRefsOfHashes = GraphBuilder.prepareRefsMap(refs);
    }

    @NotNull
    private static MultiMap<Integer, VcsRef> prepareRefsMap(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "prepareRefsMap"));
        }
        MultiMap map = MultiMap.create();
        for (VcsRef ref : refs) {
            map.putValue((Object)ref.getCommitIndex(), (Object)ref);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "prepareRefsMap"));
        }
        return multiMap;
    }

    public GraphBuilder(MutableGraph graph, Collection<VcsRef> refs) {
        this(graph, new HashMap<Integer, MutableNode>(), new MutableNodeRow(graph, 0), refs);
    }

    public GraphBuilder(Collection<VcsRef> refs) {
        this(new MutableGraph(), refs);
    }

    @NotNull
    private Collection<VcsRef> findRefForHash(int hash) {
        Collection collection = this.myRefsOfHashes.get((Object)hash);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "findRefForHash"));
        }
        return collection;
    }

    private MutableNode addCurrentCommitAndFinishRow(int commitHash) {
        MutableNode node = this.underdoneNodes.remove(commitHash);
        if (node == null) {
            Collection<VcsRef> refs = this.findRefForHash(commitHash);
            node = GraphBuilder.createNode(commitHash, this.createBranch(commitHash, refs));
        }
        node.setType(Node.NodeType.COMMIT_NODE);
        node.setNodeRow(this.nextRow);
        this.nextRow.getInnerNodeList().add(node);
        this.graph.getAllRows().add(this.nextRow);
        this.nextRow = new MutableNodeRow(this.graph, this.nextRow.getRowIndex() + 1);
        return node;
    }

    @NotNull
    protected Branch createBranch(int commitHash, @NotNull Collection<VcsRef> refs) {
        int oneOfHeads;
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "createBranch"));
        }
        if (refs.isEmpty()) {
            LOG.error("Ref should exist for this node. Hash: " + commitHash);
            oneOfHeads = -1;
        } else {
            oneOfHeads = refs.iterator().next().getCommitIndex();
        }
        Branch branch = new Branch(commitHash, refs, oneOfHeads);
        if (branch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "createBranch"));
        }
        return branch;
    }

    private void addParent(MutableNode node, int parentHash, Branch branch) {
        MutableNode parentNode = this.underdoneNodes.remove(parentHash);
        if (parentNode == null) {
            parentNode = GraphBuilder.createNode(parentHash, branch);
        }
        GraphBuilder.createUsualEdge(node, parentNode, branch);
        this.underdoneNodes.put(parentHash, parentNode);
    }

    private static MutableNode createNode(int hash, Branch branch) {
        return new MutableNode(branch, hash);
    }

    private void append(@NotNull GraphCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "append"));
        }
        MutableNode node = this.addCurrentCommitAndFinishRow(commit.getIndex());
        int[] parents = commit.getParentIndices();
        Branch branch = node.getBranch();
        if (parents.length == 1) {
            this.addParent(node, parents[0], branch);
        } else {
            for (int parentHash : parents) {
                Collection<VcsRef> refs = this.findRefForHash(node.getCommitIndex());
                this.addParent(node, parentHash, new Branch(node.getCommitIndex(), parentHash, refs, branch.getOneOfHeads()));
            }
        }
    }

    private void lastActions() {
        Set<Integer> notReadiedCommitHashes = this.underdoneNodes.keySet();
        for (Integer hash : notReadiedCommitHashes) {
            MutableNode underdoneNode = this.underdoneNodes.get(hash);
            underdoneNode.setNodeRow(this.nextRow);
            underdoneNode.setType(Node.NodeType.END_COMMIT_NODE);
            this.nextRow.getInnerNodeList().add(underdoneNode);
        }
        if (!this.nextRow.getInnerNodeList().isEmpty()) {
            this.graph.getAllRows().add(this.nextRow);
        }
    }

    @NotNull
    public MutableGraph runBuild(@NotNull List<? extends GraphCommit> commitParentses) {
        if (commitParentses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "runBuild"));
        }
        for (GraphCommit graphCommit : commitParentses) {
            this.append(graphCommit);
        }
        this.lastActions();
        this.graph.updateVisibleRows();
        MutableGraph mutableGraph = this.graph;
        if (mutableGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/mutable/GraphBuilder", "runBuild"));
        }
        return mutableGraph;
    }
}

