/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.render.ColorGenerator;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GraphColorManagerImpl
implements GraphColorManager {
    private static final Logger LOG = Logger.getInstance(GraphColorManagerImpl.class);
    private static final JBColor DEFAULT_COLOR = JBColor.BLACK;
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final NotNullFunction<Integer, Hash> myHashGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogRefManager> myRefManagers;
    @NotNull
    private final LinkedHashMap<Integer, Integer> myErrorWasReported;

    public GraphColorManagerImpl(@NotNull RefsModel refsModel, @NotNull NotNullFunction<Integer, Hash> hashGetter, @NotNull Map<VirtualFile, VcsLogRefManager> refManagers) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        if (hashGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        if (refManagers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        this.myErrorWasReported = new LinkedHashMap<Integer, Integer>(10){

            protected boolean removeEldestEntry(Map.Entry<Integer, Integer> eldest) {
                return this.size() > 100;
            }
        };
        this.myRefsModel = refsModel;
        this.myHashGetter = hashGetter;
        this.myRefManagers = refManagers;
    }

    @NotNull
    public JBColor getColorOfBranch(int headCommit) {
        Collection<VcsRef> refs = this.myRefsModel.refsToCommit(headCommit);
        if (this.isEmptyRefs(refs, headCommit)) {
            JBColor jBColor = DEFAULT_COLOR;
            if (jBColor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getColorOfBranch"));
            }
            return jBColor;
        }
        VcsRef firstRef = (VcsRef)this.getRefManager(refs).sort(refs).get(0);
        Color color = ColorGenerator.getColor(firstRef.getName().hashCode());
        JBColor jBColor = new JBColor(color, color);
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getColorOfBranch"));
        }
        return jBColor;
    }

    private boolean isEmptyRefs(@NotNull Collection<VcsRef> refs, int head) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "isEmptyRefs"));
        }
        if (refs.isEmpty()) {
            if (!this.myErrorWasReported.containsKey((Object)head)) {
                this.myErrorWasReported.put((Object)head, (Object)head);
                LOG.error("No references found at head " + head + " which corresponds to hash " + this.myHashGetter.fun((Object)head));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public JBColor getColorOfFragment(int headCommit, int magicIndex) {
        Color color = ColorGenerator.getColor(magicIndex);
        JBColor jBColor = new JBColor(color, color);
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getColorOfFragment"));
        }
        return jBColor;
    }

    public int compareHeads(int head1, int head2) {
        VcsLogRefManager refManager2;
        if (head1 == head2) {
            return 0;
        }
        Collection<VcsRef> refs1 = this.myRefsModel.refsToCommit(head1);
        Collection<VcsRef> refs2 = this.myRefsModel.refsToCommit(head2);
        boolean firstEmpty = this.isEmptyRefs(refs1, head1);
        boolean secondEmpty = this.isEmptyRefs(refs2, head2);
        if (firstEmpty && secondEmpty) {
            return 0;
        }
        if (firstEmpty) {
            return -1;
        }
        if (secondEmpty) {
            return 1;
        }
        VcsLogRefManager refManager1 = this.getRefManager(refs1);
        if (!refManager1.equals(refManager2 = this.getRefManager(refs2))) {
            return 0;
        }
        HashMap positions = ContainerUtil.newHashMap();
        for (VcsRef ref : refs1) {
            positions.put(ref, true);
        }
        for (VcsRef ref : refs2) {
            positions.put(ref, false);
        }
        VcsRef firstRef = (VcsRef)refManager1.sort(positions.keySet()).get(0);
        return (Boolean)positions.get(firstRef) != false ? 1 : -1;
    }

    @NotNull
    private VcsLogRefManager getRefManager(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getRefManager"));
        }
        VcsLogRefManager vcsLogRefManager = this.myRefManagers.get(refs.iterator().next().getRoot());
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getRefManager"));
        }
        return vcsLogRefManager;
    }
}

