/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class VcsLogMultiRepoJoiner {
    VcsLogMultiRepoJoiner() {
    }

    @NotNull
    public List<? extends TimedVcsCommit> join(@NotNull Collection<List<? extends TimedVcsCommit>> logsFromRepos) {
        if (logsFromRepos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
        }
        if (logsFromRepos.size() == 1) {
            List<? extends TimedVcsCommit> list = logsFromRepos.iterator().next();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
            }
            return list;
        }
        int size = 0;
        for (List<? extends TimedVcsCommit> repo : logsFromRepos) {
            size += repo.size();
        }
        ArrayList<TimedVcsCommit> result = new ArrayList<TimedVcsCommit>(size);
        HashMap nextCommits = ContainerUtil.newHashMap();
        for (List<? extends TimedVcsCommit> log : logsFromRepos) {
            Iterator<? extends TimedVcsCommit> iterator = log.iterator();
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        while (!nextCommits.isEmpty()) {
            TimedVcsCommit lastCommit = VcsLogMultiRepoJoiner.findLatestCommit(nextCommits.keySet());
            Iterator iterator = (Iterator)nextCommits.get(lastCommit);
            result.add(lastCommit);
            nextCommits.remove(lastCommit);
            if (!iterator.hasNext()) continue;
            nextCommits.put(iterator.next(), iterator);
        }
        ArrayList<TimedVcsCommit> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "join"));
        }
        return arrayList;
    }

    @NotNull
    private static TimedVcsCommit findLatestCommit(@NotNull Set<TimedVcsCommit> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "findLatestCommit"));
        }
        long maxTimeStamp = Long.MIN_VALUE;
        TimedVcsCommit lastCommit = null;
        for (TimedVcsCommit commit : commits) {
            if (commit.getTime() < maxTimeStamp) continue;
            maxTimeStamp = commit.getTime();
            lastCommit = commit;
        }
        assert (lastCommit != null);
        TimedVcsCommit timedVcsCommit = lastCommit;
        if (timedVcsCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner", "findLatestCommit"));
        }
        return timedVcsCommit;
    }
}

